/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.betterstats.mcbs.view.editor;

import com.thecsdev.betterstats.api.client.registry.BClientRegistries;
import com.thecsdev.betterstats.api.mcbs.controller.McbsEditor;
import com.thecsdev.betterstats.api.mcbs.view.menubar.MenubarItem;
import com.thecsdev.betterstats.resources.BSSSprites;
import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.scene.Node;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.panel.TPanelElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import com.thecsdev.commonmc.api.client.gui.widget.TButtonWidget;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public final class MenubarPanel
extends TElement {
    @NotNull
    private final McbsEditor mcbsEditor;

    public MenubarPanel(@NotNull McbsEditor mcbsEditor) {
        this.mcbsEditor = Objects.requireNonNull(mcbsEditor);
    }

    public final void renderCallback(@NotNull TGuiGraphics pencil) {
        Bounds2i bb = this.getBounds();
        pencil.drawGuiSprite(BSSSprites.gui_editor_menubar_background(), bb.x, bb.y, bb.width, bb.height, -1);
    }

    public final void postRenderCallback(@NotNull TGuiGraphics pencil) {
        Bounds2i bb = this.getBounds();
        pencil.drawGuiSprite(BSSSprites.gui_editor_menubar_foreground(), bb.x, bb.y, bb.width, bb.height, -1);
    }

    protected final void initCallback() {
        TPanelElement.Paintable panel = new TPanelElement.Paintable(0, 0, 0x33FFFFFF);
        panel.setBounds(this.getBounds().add(1, 1, -2, -2));
        panel.scrollPaddingProperty().set((Object)0, MenubarPanel.class);
        this.add((Node)panel);
        for (Map.Entry<class_2960, MenubarItem> item : BClientRegistries.MENUBAR_ITEM.entrySet()) {
            try {
                Bounds2i pcbb = panel.getContentBounds();
                class_2561 label = Objects.requireNonNull(item.getValue().getDisplayName(), "Missing display name");
                Button button = new Button();
                button.getLabel().setText(label);
                button.setBounds(pcbb.endX, pcbb.y, ((class_327)button.getLabel().fontProperty().get()).method_27525((class_5348)label) + 10, panel.getBounds().height);
                button.contextMenuProperty().set(__ -> Objects.requireNonNull(((MenubarItem)item.getValue()).createContextMenu(Objects.requireNonNull(__.getClient(), "Missing 'client' instance"), this.mcbsEditor), "Menubar item failed to produce a context menu, ID " + String.valueOf(item.getKey())), MenubarPanel.class);
                button.eClicked.register(TElement::showContextMenu);
                panel.add((Node)button);
            }
            catch (Exception e) {
                throw new class_148(new class_128("Something went wrong creating menubar item ID " + String.valueOf(item.getKey()), (Throwable)e));
            }
        }
    }

    private static final class Button
    extends TButtonWidget.Transparent {
        private Button() {
        }

        protected final void initCallback() {
            this.getLabel().setBounds(this.getBounds());
            this.add((Node)this.getLabel());
        }

        public final void renderCallback(@NotNull TGuiGraphics pencil) {
            if (!this.isHoveredOrFocused()) {
                return;
            }
            Bounds2i bb = this.getBounds();
            pencil.fillColor(bb.x, bb.y, bb.width, bb.height, 0x33FFFFFF);
        }
    }
}

