/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.betterstats.mcbs.view.editor;

import com.thecsdev.betterstats.api.mcbs.controller.McbsEditor;
import com.thecsdev.betterstats.api.mcbs.controller.tab.McbsEditorTab;
import com.thecsdev.betterstats.api.mcbs.view.McbsEditorGUI;
import com.thecsdev.betterstats.resources.BSSSprites;
import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.scene.Node;
import com.thecsdev.common.util.enumerations.CompassDirection;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.panel.TPanelElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import com.thecsdev.commonmc.api.client.gui.widget.TButtonWidget;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public final class TabStripPanel
extends TElement {
    @NotNull
    private final McbsEditor mcbsEditor;

    public TabStripPanel(@NotNull McbsEditor mcbsEditor) throws NullPointerException {
        this.mcbsEditor = Objects.requireNonNull(mcbsEditor);
    }

    public final void renderCallback(@NotNull TGuiGraphics pencil) {
        Bounds2i bb = this.getBounds();
        pencil.drawGuiSprite(BSSSprites.gui_editor_tabStrip_background(), bb.x, bb.y, bb.width, bb.height, -1);
    }

    public final void postRenderCallback(@NotNull TGuiGraphics pencil) {
        Bounds2i bb = this.getBounds();
        pencil.drawGuiSprite(BSSSprites.gui_editor_tabStrip_foreground(), bb.x, bb.y, bb.width, bb.height, -1);
    }

    protected final void initCallback() {
        TPanelElement.Paintable panel = new TPanelElement.Paintable(0, 0, 0x33FFFFFF);
        panel.setBounds(this.getBounds());
        panel.scrollPaddingProperty().set((Object)0, McbsEditorGUI.class);
        this.add((Node)panel);
        for (McbsEditorTab tab : this.mcbsEditor.getTabsReadOnly()) {
            this.initEntry((TPanelElement)panel, tab);
        }
    }

    private final void initEntry(@NotNull TPanelElement panel, @NotNull McbsEditorTab tab) {
        Objects.requireNonNull(panel);
        Objects.requireNonNull(tab);
        EntryElement entry = new EntryElement(tab);
        Bounds2i pcbb = panel.getContentBounds();
        entry.setBounds(pcbb.endX, pcbb.y, entry.getLabel().getTextWidth() + panel.getBounds().height + 5, panel.getBounds().height);
        panel.add((Node)entry);
    }

    private final class EntryElement
    extends TButtonWidget.Transparent {
        @NotNull
        private final McbsEditorTab tab;

        public EntryElement(McbsEditorTab tab) {
            this.tab = Objects.requireNonNull(tab);
            this.enabledProperty().set((Object)(!this.isSelected() ? 1 : 0), TabStripPanel.class);
            this.getLabel().setText(tab.getDisplayName());
            this.getLabel().textAlignmentProperty().set((Object)CompassDirection.WEST, EntryElement.class);
            this.getLabel().textScaleProperty().set((Object)0.85, EntryElement.class);
            this.getLabel().textColorProperty().set((Object)(this.isSelected() ? -3807390 : -285212673), EntryElement.class);
            this.eClicked.register(btn -> {
                btn.enabledProperty().set((Object)false, TabStripPanel.class);
                TabStripPanel.this.mcbsEditor.setCurrentTab(this.tab);
            });
        }

        public final void renderCallback(@NotNull TGuiGraphics pencil) {
            Bounds2i bb = this.getBounds();
            pencil.drawGuiSprite(this.isSelected() ? BSSSprites.gui_editor_tabStrip_entrySelected() : BSSSprites.gui_editor_tabStrip_entry(), bb.x, bb.y, bb.width, bb.height, -1);
        }

        protected final void initCallback() {
            super.initCallback();
            Bounds2i bb = this.getBounds();
            TButtonWidget.Paintable btn_close = new TButtonWidget.Paintable(0, 0, 0x33888888);
            btn_close.setBounds(bb.endX - bb.height, bb.y, bb.height, bb.height);
            btn_close.getLabel().setText((class_2561)class_2561.method_43470((String)"x"));
            btn_close.getLabel().textAlignmentProperty().set((Object)CompassDirection.CENTER, EntryElement.class);
            btn_close.getLabel().textScaleProperty().set((Object)0.7, EntryElement.class);
            btn_close.getLabel().textColorProperty().set((Object)-1140850689, EntryElement.class);
            btn_close.eClicked.register(__ -> TabStripPanel.this.mcbsEditor.removeTab(this.tab));
            this.add((Node)btn_close);
        }

        private final boolean isSelected() {
            return TabStripPanel.this.mcbsEditor.getCurrentTab() == this.tab;
        }
    }
}

