/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.betterstats.mcbs.view.menubar;

import com.thecsdev.betterstats.api.mcbs.controller.McbsEditor;
import com.thecsdev.betterstats.api.mcbs.controller.tab.McbsEditorFileTab;
import com.thecsdev.betterstats.api.mcbs.controller.tab.McbsEditorSettingsTab;
import com.thecsdev.betterstats.api.mcbs.controller.tab.McbsEditorTab;
import com.thecsdev.betterstats.api.mcbs.view.menubar.MenubarItem;
import com.thecsdev.betterstats.resources.BSSLang;
import com.thecsdev.betterstats.resources.BSSSprites;
import com.thecsdev.common.util.TUtils;
import com.thecsdev.commonmc.api.client.gui.ctxmenu.TContextMenu;
import com.thecsdev.commonmc.api.client.gui.screen.TFileChooserScreen;
import com.thecsdev.commonmc.resources.TCDCSprites;
import com.thecsdev.commonmc.resources.TComponent;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public final class MenubarItemFile
extends MenubarItem {
    public static final MenubarItemFile INSTANCE = new MenubarItemFile();

    @Override
    @NotNull
    public final class_2561 getDisplayName() {
        return BSSLang.gui_menubar_file();
    }

    @Override
    @NotNull
    public final TContextMenu createContextMenu(@NotNull class_310 client, @NotNull McbsEditor mcbsEditor) {
        Objects.requireNonNull(client, "Missing 'client' instance");
        Objects.requireNonNull(mcbsEditor, "Missing 'editor' instance");
        TContextMenu.Builder builder = new TContextMenu.Builder(client);
        builder.addButton((class_2561)TComponent.gui((class_2960)TCDCSprites.gui_icon_fsFolder()).method_27693(" ").method_10852((class_2561)BSSLang.gui_menubar_file_open()), __ -> MenubarItemFile.showOpenFileDialog(client, mcbsEditor));
        if (mcbsEditor.getCurrentTab() instanceof McbsEditorFileTab) {
            builder.addButton((class_2561)TComponent.air().method_27693(" ").method_10852((class_2561)BSSLang.gui_menubar_file_saveAs()), __ -> MenubarItemFile.showSaveFileDialog(client, mcbsEditor));
        }
        builder.addSeparator();
        builder.addButton((class_2561)TComponent.gui((class_2960)BSSSprites.gui_icon_settings()).method_27693(" ").method_10852((class_2561)BSSLang.gui_menubar_file_settings()), __ -> mcbsEditor.addTab(McbsEditorSettingsTab.INSTANCE, true));
        builder.addButton((class_2561)TComponent.gui((class_2960)BSSSprites.gui_icon_close()).method_27693(" ").method_10852((class_2561)BSSLang.gui_menubar_file_close()), __ -> Optional.ofNullable(client.field_1755).ifPresent(class_437::method_25419));
        return builder.build();
    }

    @ApiStatus.Internal
    private static final void showOpenFileDialog(@NotNull class_310 client, @NotNull McbsEditor mcbsEditor) throws NullPointerException {
        class_437 lastScreen = client.field_1755;
        TFileChooserScreen dialog = new TFileChooserScreen.Builder(TFileChooserScreen.Mode.CHOOSE_FILE).setLastScreen(lastScreen).setFileFilter(TFileChooserScreen.FileFilter.extname((String)"json")).build((result, file) -> TUtils.uncheckedCall(() -> {
            if (result != TFileChooserScreen.Result.APPROVE || file == null || !file.exists()) {
                return;
            }
            mcbsEditor.addTab(new McbsEditorFileTab((File)file), true);
        }));
        client.method_1507((class_437)dialog.getAsScreen());
    }

    @ApiStatus.Internal
    private static final void showSaveFileDialog(@NotNull class_310 client, @NotNull McbsEditor mcbsEditor) throws NullPointerException {
        McbsEditorFileTab meft;
        McbsEditorFileTab fileTab;
        McbsEditorTab mcbsEditorTab = mcbsEditor.getCurrentTab();
        McbsEditorFileTab mcbsEditorFileTab = fileTab = mcbsEditorTab instanceof McbsEditorFileTab ? (meft = (McbsEditorFileTab)mcbsEditorTab) : null;
        if (fileTab == null) {
            return;
        }
        class_437 lastScreen = client.field_1755;
        TFileChooserScreen dialog = new TFileChooserScreen.Builder(TFileChooserScreen.Mode.CREATE_FILE).setLastScreen(lastScreen).setFileFilter(TFileChooserScreen.FileFilter.extname((String)"json")).build((result, file) -> TUtils.uncheckedCall(() -> {
            if (result != TFileChooserScreen.Result.APPROVE || file == null) {
                return;
            }
            fileTab.saveAs((File)file);
        }));
        client.method_1507((class_437)dialog.getAsScreen());
    }
}

