/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.betterstats.mcbs.view.statsview;

import com.thecsdev.betterstats.api.mcbs.view.statsview.StatsView;
import com.thecsdev.betterstats.api.mcbs.view.statsview.StatsViewUtils;
import com.thecsdev.betterstats.client.gui.panel.StatsPageChooser;
import com.thecsdev.betterstats.mcbs.view.statsview.SubjectStatsView;
import com.thecsdev.betterstats.resources.BSSLang;
import com.thecsdev.betterstats.resources.BSSSprites;
import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.scene.Node;
import com.thecsdev.commonmc.api.client.gui.misc.TTextureElement;
import com.thecsdev.commonmc.api.client.gui.panel.TPanelElement;
import com.thecsdev.commonmc.api.client.gui.tooltip.TTooltip;
import com.thecsdev.commonmc.api.client.gui.widget.TDropdownWidget;
import com.thecsdev.commonmc.api.client.gui.widget.stats.TCustomStatWidget;
import com.thecsdev.commonmc.api.stats.IStatsProvider;
import com.thecsdev.commonmc.api.stats.util.CustomStat;
import com.thecsdev.commonmc.api.stats.util.StatFormatterOverride;
import com.thecsdev.commonmc.api.util.modinfo.ModInfoProvider;
import com.thecsdev.commonmc.resources.TComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3446;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public final class StatsViewGeneral
extends SubjectStatsView<CustomStat> {
    public static final StatsViewGeneral INSTANCE = new StatsViewGeneral();

    private StatsViewGeneral() {
    }

    @Override
    @NotNull
    public final class_2561 getDisplayName() {
        return TComponent.item((String)"item/paper").method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"stat.generalButton"));
    }

    @Override
    public final void initFilters(@NotNull StatsView.FiltersInitContext context) {
        super.initFilters(context);
        SortBy.initFilter(context);
        GroupBy.initFilter(context);
        DistanceUnit.initFilter(context);
        TimeUnit.initFilter(context);
    }

    @Override
    public final void initStats(@NotNull StatsView.StatsInitContext context) {
        Collection allStats = CustomStat.getCustomStats((IStatsProvider)context.getStats(), this.getStatsPredicate(context.getFilters()), this.getStatsSorter(context.getFilters()));
        if (allStats.isEmpty()) {
            return;
        }
        int perPage = 200;
        Collection pagedStats = StatsPageChooser.applyFilter(allStats, context.getFilters(), 200);
        StatsPageChooser.initPanel(context.getPanel(), context.getFilters(), 200, allStats.size());
        this.getStatsGrouper(context.getFilters()).apply(pagedStats).forEach((gName, gStats) -> StatsViewUtils.initGeneralStats(context.getPanel(), gName, gStats, el -> this.postProcessWidget(context, (TCustomStatWidget)el)));
        StatsPageChooser.initPanel(context.getPanel(), context.getFilters(), 200, allStats.size());
    }

    private final void postProcessWidget(@NotNull StatsView.StatsInitContext context, @NotNull TCustomStatWidget widget) {
        CustomStat stat = (CustomStat)widget.statProperty().get();
        assert (stat != null);
        if (stat.isDistance()) {
            DistanceUnit distanceUnit = (DistanceUnit)((Object)context.getFilters().getProperty(DistanceUnit.class, DistanceUnit.FID, (Object)DistanceUnit.VANILLA));
            widget.formatterOverrideProperty().set((Object)distanceUnit.getFormatter(), StatsViewGeneral.class);
        } else if (stat.isTime()) {
            TimeUnit timeUnit = (TimeUnit)((Object)context.getFilters().getProperty(TimeUnit.class, TimeUnit.FID, (Object)TimeUnit.VANILLA));
            widget.formatterOverrideProperty().set((Object)timeUnit.getFormatter(), StatsViewGeneral.class);
        }
    }

    @Override
    @NotNull
    protected final Comparator<CustomStat> getStatsSorter(@NotNull StatsView.Filters filters) throws NullPointerException {
        return ((SortBy)((Object)filters.getProperty(SortBy.class, SortBy.FID, (Object)SortBy.ALPHABETICAL))).getStatsSorter();
    }

    @Override
    @NotNull
    protected final Function<Iterable<CustomStat>, LinkedHashMap<class_2561, Iterable<CustomStat>>> getStatsGrouper(@NotNull StatsView.Filters filters) {
        return ((GroupBy)((Object)filters.getProperty(GroupBy.class, GroupBy.FID, (Object)GroupBy.MOD))).getStatsGrouper();
    }

    public static enum SortBy implements TDropdownWidget.Entry
    {
        VANILLA((class_2561)class_2561.method_43470((String)"-"), (o1, o2) -> 0),
        ALPHABETICAL((class_2561)class_2561.method_43470((String)"A-Z"), Comparator.comparing(stat -> stat.getSubjectDisplayName().getString())),
        LACITEBAHPLA((class_2561)class_2561.method_43470((String)"Z-A"), ALPHABETICAL.getStatsSorter().reversed()),
        INCREMENTAL((class_2561)class_2561.method_43470((String)"0-9"), Comparator.comparing(CustomStat::getValue)),
        DECREMENTAL((class_2561)class_2561.method_43470((String)"9-0"), INCREMENTAL.getStatsSorter().reversed());

        public static final class_2960 FID;
        @NotNull
        private final class_2561 name;
        @NotNull
        private final Comparator<CustomStat> sorter;

        private SortBy(class_2561 name, Comparator<CustomStat> sorter) {
            this.name = Objects.requireNonNull(name);
            this.sorter = sorter;
        }

        @NotNull
        public final class_2561 getDisplayName() {
            return this.name;
        }

        @NotNull
        public final Comparator<CustomStat> getStatsSorter() {
            return this.sorter;
        }

        public static final void initFilter(@NotNull StatsView.FiltersInitContext context) throws NullPointerException {
            TPanelElement panel = context.getPanel();
            Bounds2i nextY = panel.computeNextYBounds(20, 3);
            TTextureElement icon = new TTextureElement(BSSSprites.gui_icon_filterSort());
            icon.setBounds(nextY.x, nextY.y, 20, nextY.height);
            panel.add((Node)icon);
            TDropdownWidget dropdown = new TDropdownWidget();
            dropdown.setBounds(nextY.x + 25, nextY.y, nextY.width - 25, nextY.height);
            Collections.addAll(dropdown.getEntries(), SortBy.values());
            dropdown.tooltipProperty().set(__ -> TTooltip.of((class_2561)BSSLang.gui_statsview_filter_sortBy()), SortBy.class);
            panel.add((Node)dropdown);
            dropdown.selectedEntryProperty().set((Object)((SortBy)((Object)context.getFilters().getProperty(SortBy.class, FID, (Object)ALPHABETICAL))), SortBy.class);
            dropdown.selectedEntryProperty().addChangeListener((p, o, n) -> context.getFilters().setProperty(SortBy.class, FID, n));
        }

        static {
            FID = class_2960.method_60655((String)"betterstats", (String)"general_sort_by");
        }
    }

    public static final class GroupBy
    extends Enum<GroupBy>
    implements TDropdownWidget.Entry {
        public static final /* enum */ GroupBy ALL = new GroupBy((class_2561)BSSLang.gui_statsview_filter_groupBy_all(), stats -> {
            LinkedHashMap<class_5250, Iterable> map = new LinkedHashMap<class_5250, Iterable>();
            map.put(class_2561.method_43470((String)"*"), (Iterable)stats);
            return map;
        });
        public static final /* enum */ GroupBy MOD = new GroupBy((class_2561)BSSLang.gui_statsview_filter_groupBy_mod(), stats -> {
            LinkedHashMap<String, ArrayList> map = new LinkedHashMap<String, ArrayList>();
            for (CustomStat stat : stats) {
                map.computeIfAbsent(stat.getSubjectID().method_12836(), __ -> new ArrayList()).add(stat);
            }
            return map.entrySet().stream().collect(Collectors.toMap(entry -> {
                assert (ModInfoProvider.getInstance() != null);
                return ModInfoProvider.getInstance().getModInfo((String)entry.getKey()).getName();
            }, Map.Entry::getValue, (existing, replacement) -> existing, LinkedHashMap::new));
        });
        public static final class_2960 FID;
        @NotNull
        private final class_2561 name;
        @NotNull
        private final Function<Iterable<CustomStat>, LinkedHashMap<class_2561, Iterable<CustomStat>>> grouper;
        private static final /* synthetic */ GroupBy[] $VALUES;

        public static GroupBy[] values() {
            return (GroupBy[])$VALUES.clone();
        }

        public static GroupBy valueOf(String name) {
            return Enum.valueOf(GroupBy.class, name);
        }

        private GroupBy(class_2561 name, Function<Iterable<CustomStat>, LinkedHashMap<class_2561, Iterable<CustomStat>>> grouper) {
            this.name = Objects.requireNonNull(name);
            this.grouper = grouper;
        }

        @NotNull
        public final class_2561 getDisplayName() {
            return this.name;
        }

        @NotNull
        public final Function<Iterable<CustomStat>, LinkedHashMap<class_2561, Iterable<CustomStat>>> getStatsGrouper() {
            return this.grouper;
        }

        public static final void initFilter(@NotNull StatsView.FiltersInitContext context) throws NullPointerException {
            TPanelElement panel = context.getPanel();
            Bounds2i nextY = panel.computeNextYBounds(20, 3);
            TTextureElement icon = new TTextureElement(BSSSprites.gui_icon_filterGroup());
            icon.setBounds(nextY.x, nextY.y, 20, nextY.height);
            panel.add((Node)icon);
            TDropdownWidget dropdown = new TDropdownWidget();
            dropdown.setBounds(nextY.x + 25, nextY.y, nextY.width - 25, nextY.height);
            Collections.addAll(dropdown.getEntries(), GroupBy.values());
            dropdown.tooltipProperty().set(__ -> TTooltip.of((class_2561)BSSLang.gui_statsview_filter_groupBy()), GroupBy.class);
            panel.add((Node)dropdown);
            dropdown.selectedEntryProperty().set((Object)((GroupBy)((Object)context.getFilters().getProperty(GroupBy.class, FID, (Object)MOD))), GroupBy.class);
            dropdown.selectedEntryProperty().addChangeListener((p, o, n) -> context.getFilters().setProperty(GroupBy.class, FID, n));
        }

        private static /* synthetic */ GroupBy[] $values() {
            return new GroupBy[]{ALL, MOD};
        }

        static {
            $VALUES = GroupBy.$values();
            FID = class_2960.method_60655((String)"betterstats", (String)"general_group_by");
        }
    }

    public static enum DistanceUnit implements TDropdownWidget.Entry
    {
        VANILLA((class_2561)class_2561.method_43470((String)"-"), StatFormatterOverride.DEFAULT),
        CENTIMETER((class_2561)class_2561.method_43470((String)"cm"), (f, v) -> f != class_3446.field_16977 ? f.format(v) : String.format("%d cm", v)),
        METER((class_2561)class_2561.method_43470((String)"m"), (f, v) -> f != class_3446.field_16977 ? f.format(v) : String.format("%.2f m", (double)v / 100.0)),
        KILOMETER((class_2561)class_2561.method_43470((String)"km"), (f, v) -> f != class_3446.field_16977 ? f.format(v) : String.format("%.3f km", (double)v / 100000.0)),
        INCH((class_2561)class_2561.method_43470((String)"in"), (f, v) -> f != class_3446.field_16977 ? f.format(v) : String.format("%.2f in", (double)v / 2.54)),
        FOOT((class_2561)class_2561.method_43470((String)"ft"), (f, v) -> f != class_3446.field_16977 ? f.format(v) : String.format("%.2f ft", (double)v / 30.48)),
        YARD((class_2561)class_2561.method_43470((String)"yd"), (f, v) -> f != class_3446.field_16977 ? f.format(v) : String.format("%.2f yd", (double)v / 91.44)),
        MILE((class_2561)class_2561.method_43470((String)"mi"), (f, v) -> f != class_3446.field_16977 ? f.format(v) : String.format("%.3f mi", (double)v / 160934.4));

        public static final class_2960 FID;
        @NotNull
        private final class_2561 name;
        @NotNull
        private final StatFormatterOverride formatter;

        private DistanceUnit(class_2561 name, StatFormatterOverride formatter) {
            this.name = Objects.requireNonNull(name);
            this.formatter = Objects.requireNonNull(formatter);
        }

        @NotNull
        public final class_2561 getDisplayName() {
            return this.name;
        }

        @NotNull
        public final StatFormatterOverride getFormatter() {
            return this.formatter;
        }

        public static final void initFilter(@NotNull StatsView.FiltersInitContext context) throws NullPointerException {
            TPanelElement panel = context.getPanel();
            Bounds2i nextY = panel.computeNextYBounds(20, 3);
            TTextureElement icon = new TTextureElement(BSSSprites.gui_icon_filterUnitDist());
            icon.setBounds(nextY.x, nextY.y, 20, nextY.height);
            panel.add((Node)icon);
            TDropdownWidget dropdown = new TDropdownWidget();
            dropdown.setBounds(nextY.x + 25, nextY.y, nextY.width - 25, nextY.height);
            Collections.addAll(dropdown.getEntries(), DistanceUnit.values());
            dropdown.tooltipProperty().set(__ -> TTooltip.of((class_2561)BSSLang.gui_statsview_filter_distanceUnit()), DistanceUnit.class);
            panel.add((Node)dropdown);
            dropdown.selectedEntryProperty().set((Object)((DistanceUnit)((Object)context.getFilters().getProperty(DistanceUnit.class, FID, (Object)VANILLA))), DistanceUnit.class);
            dropdown.selectedEntryProperty().addChangeListener((p, o, n) -> context.getFilters().setProperty(DistanceUnit.class, FID, n));
        }

        static {
            FID = class_2960.method_60655((String)"betterstats", (String)"distance_unit");
        }
    }

    public static enum TimeUnit implements TDropdownWidget.Entry
    {
        VANILLA((class_2561)class_2561.method_43470((String)"-"), StatFormatterOverride.DEFAULT),
        MILLISECOND((class_2561)class_2561.method_43470((String)"ms"), (f, v) -> f != class_3446.field_16979 ? f.format(v) : String.format("%.2f ms", (double)v / 0.02)),
        TICK((class_2561)class_2561.method_43470((String)"0.05s"), (f, v) -> f != class_3446.field_16979 ? f.format(v) : String.format("%d t", v)),
        SECOND((class_2561)class_2561.method_43470((String)"s"), (f, v) -> f != class_3446.field_16979 ? f.format(v) : String.format("%.2f s", (double)v / 20.0)),
        MINUTE((class_2561)class_2561.method_43470((String)"m"), (f, v) -> f != class_3446.field_16979 ? f.format(v) : String.format("%.2f m", (double)v / 1200.0)),
        HOUR((class_2561)class_2561.method_43470((String)"h"), (f, v) -> f != class_3446.field_16979 ? f.format(v) : String.format("%.2f h", (double)v / 72000.0)),
        DAY((class_2561)class_2561.method_43470((String)"d"), (f, v) -> f != class_3446.field_16979 ? f.format(v) : String.format("%.2f d", (double)v / 1728000.0)),
        WEEK((class_2561)class_2561.method_43470((String)"w"), (f, v) -> f != class_3446.field_16979 ? f.format(v) : String.format("%.3f w", (double)v / 1.2096E7)),
        MONTH((class_2561)class_2561.method_43470((String)"mo"), (f, v) -> f != class_3446.field_16979 ? f.format(v) : String.format("%.3f mo", (double)v / 5.184E7)),
        YEAR((class_2561)class_2561.method_43470((String)"y"), (f, v) -> f != class_3446.field_16979 ? f.format(v) : String.format("%.4f y", (double)v / 6.2208E8)),
        HHMMSSMS((class_2561)class_2561.method_43470((String)"hh:mm:ss.ms"), (f, v) -> {
            if (f != class_3446.field_16979) {
                return f.format(v);
            }
            int totalMilliseconds = v * 50;
            int hours = totalMilliseconds / 3600000;
            int minutes = totalMilliseconds % 3600000 / 60000;
            int seconds = totalMilliseconds % 60000 / 1000;
            int millis = totalMilliseconds % 1000;
            return String.format("%02d:%02d:%02d.%03d", hours, minutes, seconds, millis);
        });

        public static final class_2960 FID;
        @NotNull
        private final class_2561 name;
        @NotNull
        private final StatFormatterOverride formatter;

        private TimeUnit(class_2561 name, StatFormatterOverride formatter) {
            this.name = Objects.requireNonNull(name);
            this.formatter = Objects.requireNonNull(formatter);
        }

        @NotNull
        public final class_2561 getDisplayName() {
            return this.name;
        }

        @NotNull
        public final StatFormatterOverride getFormatter() {
            return this.formatter;
        }

        public static final void initFilter(@NotNull StatsView.FiltersInitContext context) throws NullPointerException {
            TPanelElement panel = context.getPanel();
            Bounds2i nextY = panel.computeNextYBounds(20, 3);
            TTextureElement icon = new TTextureElement(BSSSprites.gui_icon_filterUnitTime());
            icon.setBounds(nextY.x, nextY.y, 20, nextY.height);
            panel.add((Node)icon);
            TDropdownWidget dropdown = new TDropdownWidget();
            dropdown.setBounds(nextY.x + 25, nextY.y, nextY.width - 25, nextY.height);
            Collections.addAll(dropdown.getEntries(), TimeUnit.values());
            dropdown.tooltipProperty().set(__ -> TTooltip.of((class_2561)BSSLang.gui_statsview_filter_timeUnit()), TimeUnit.class);
            panel.add((Node)dropdown);
            dropdown.selectedEntryProperty().set((Object)((TimeUnit)((Object)context.getFilters().getProperty(TimeUnit.class, FID, (Object)VANILLA))), TimeUnit.class);
            dropdown.selectedEntryProperty().addChangeListener((p, o, n) -> context.getFilters().setProperty(TimeUnit.class, FID, n));
        }

        static {
            FID = class_2960.method_60655((String)"betterstats", (String)"time_unit");
        }
    }
}

