/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.betterstats.mcbs.view.statsview;

import com.thecsdev.betterstats.BetterStats;
import com.thecsdev.betterstats.api.mcbs.view.statsview.StatsView;
import com.thecsdev.betterstats.api.mcbs.view.statsview.StatsViewUtils;
import com.thecsdev.betterstats.client.gui.panel.StatsPageChooser;
import com.thecsdev.betterstats.client.gui.panel.StatsSummaryPanel;
import com.thecsdev.betterstats.mcbs.view.statsview.StatsViewHunter;
import com.thecsdev.betterstats.mcbs.view.statsview.SubjectStatsView;
import com.thecsdev.betterstats.resources.BSSLang;
import com.thecsdev.betterstats.resources.BSSSprites;
import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.scene.Node;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.commonmc.api.client.gui.ctxmenu.TContextMenu;
import com.thecsdev.commonmc.api.client.gui.misc.TTextureElement;
import com.thecsdev.commonmc.api.client.gui.panel.TPanelElement;
import com.thecsdev.commonmc.api.client.gui.tooltip.TTooltip;
import com.thecsdev.commonmc.api.client.gui.widget.TDropdownWidget;
import com.thecsdev.commonmc.api.client.gui.widget.stats.TEntityStatsWidget;
import com.thecsdev.commonmc.api.stats.IStatsProvider;
import com.thecsdev.commonmc.api.stats.util.EntityStats;
import com.thecsdev.commonmc.api.util.modinfo.ModInfoProvider;
import com.thecsdev.commonmc.resources.TComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3448;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public sealed class StatsViewMobs
extends SubjectStatsView<EntityStats>
permits StatsViewHunter {
    public static final StatsViewMobs INSTANCE = new StatsViewMobs();
    private static final Function<TEntityStatsWidget, TContextMenu> CTX_MENU = widget -> {
        EntityStats stats = (EntityStats)widget.statsProperty().get();
        assert (stats != null);
        TContextMenu.Builder builder = new TContextMenu.Builder(Objects.requireNonNull(widget.getClient()));
        if (Objects.equals(stats.getSubjectID().method_12836(), "minecraft")) {
            String url_wiki = String.format("https://minecraft.wiki/w/%s", stats.getSubjectID().method_12832());
            builder.addButton((class_2561)TComponent.gui((class_2960)BSSSprites.gui_icon_faviconWiki()).method_27693(" ").method_10852((class_2561)BSSLang.gui_statsview_stats_ctxMenu_viewOnWiki()), __ -> class_156.method_668().method_670(url_wiki));
        }
        builder.addButton((class_2561)TComponent.gui((class_2960)BSSSprites.gui_icon_close()).method_27693(" ").method_10852((class_2561)BSSLang.gui_menubar_file_close()), __ -> {});
        return builder.build();
    };

    protected StatsViewMobs() {
    }

    @Override
    @NotNull
    public class_2561 getDisplayName() {
        return TComponent.head((String)"MHF_Pig").method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"stat.mobsButton"));
    }

    @Override
    public final void initFilters(@NotNull StatsView.FiltersInitContext context) {
        super.initFilters(context);
        SortBy.initFilter(context);
        GroupBy.initFilter(context);
    }

    @Override
    public void initStats(@NotNull StatsView.StatsInitContext context) {
        Collection allStats = EntityStats.getEntityStats((IStatsProvider)context.getStats(), this.getStatsPredicate(context.getFilters()), this.getStatsSorter(context.getFilters()));
        if (allStats.isEmpty()) {
            return;
        }
        int perPage = 200;
        Collection pagedStats = StatsPageChooser.applyFilter(allStats, context.getFilters(), 200);
        StatsPageChooser.initPanel(context.getPanel(), context.getFilters(), 200, allStats.size());
        this.getStatsGrouper(context.getFilters()).apply(pagedStats).forEach((gName, gStats) -> StatsViewUtils.initMobStats(context.getPanel(), gName, gStats, widget -> this.postProcessWidget(context, (TEntityStatsWidget)widget)));
        StatsPageChooser.initPanel(context.getPanel(), context.getFilters(), 200, allStats.size());
        StatsSummaryPanel.initPanel(context.getPanel(), allStats);
    }

    @Virtual
    protected void postProcessWidget(@NotNull StatsView.StatsInitContext context, @NotNull TEntityStatsWidget widget) {
        EntityStats stats = (EntityStats)widget.statsProperty().get();
        assert (stats != null);
        widget.contextMenuProperty().set(CTX_MENU, StatsViewMobs.class);
        widget.followsCursorProperty().set((Object)BetterStats.getConfig().getGuiMobsFollowCursor(), StatsViewMobs.class);
    }

    @Override
    @Virtual
    @NotNull
    protected Comparator<EntityStats> getStatsSorter(@NotNull StatsView.Filters filters) throws NullPointerException {
        return ((SortBy)filters.getProperty(SortBy.class, SortBy.FID, SortBy.VANILLA)).getStatsSorter();
    }

    @Override
    @NotNull
    protected final Function<Iterable<EntityStats>, LinkedHashMap<class_2561, Iterable<EntityStats>>> getStatsGrouper(@NotNull StatsView.Filters filters) {
        return ((GroupBy)((Object)filters.getProperty(GroupBy.class, GroupBy.FID, (Object)GroupBy.MOD))).getStatsGrouper();
    }

    public static final class SortBy
    implements TDropdownWidget.Entry {
        public static final SortBy VANILLA = new SortBy("VANILLA", (class_2561)class_2561.method_43470((String)"-"), (o1, o2) -> 0);
        public static final SortBy ALPHABETICAL = new SortBy("ALPHABETICAL", (class_2561)class_2561.method_43470((String)"A-Z"), Comparator.comparing(stat -> stat.getSubjectDisplayName().getString()));
        public static final SortBy LACITEBAHPLA = new SortBy("LACITEBAHPLA", (class_2561)class_2561.method_43470((String)"Z-A"), SortBy.ALPHABETICAL.sorter.reversed());
        public static final class_2960 FID = class_2960.method_60655((String)"betterstats", (String)"entities_sort_by");
        @NotNull
        private final Object handle;
        @NotNull
        private final class_2561 name;
        @NotNull
        private final Comparator<EntityStats> sorter;

        private SortBy(@NotNull Object handle, @NotNull class_2561 name, @NotNull Comparator<EntityStats> sorter) throws NullPointerException {
            this.handle = Objects.requireNonNull(handle);
            this.name = Objects.requireNonNull(name);
            this.sorter = Objects.requireNonNull(sorter);
        }

        @NotNull
        public final class_2561 getDisplayName() {
            return this.name;
        }

        @NotNull
        public Comparator<EntityStats> getStatsSorter() {
            return this.sorter;
        }

        public final int hashCode() {
            return Objects.hash(this.handle);
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SortBy)) {
                return false;
            }
            SortBy other = (SortBy)obj;
            return Objects.equals(this.handle, other.handle);
        }

        public static final void initFilter(@NotNull StatsView.FiltersInitContext context) throws NullPointerException {
            TPanelElement panel = context.getPanel();
            Bounds2i nextY = panel.computeNextYBounds(20, 3);
            TTextureElement icon = new TTextureElement(BSSSprites.gui_icon_filterSort());
            icon.setBounds(nextY.x, nextY.y, 20, nextY.height);
            panel.add((Node)icon);
            TDropdownWidget dropdown = new TDropdownWidget();
            dropdown.setBounds(nextY.x + 25, nextY.y, nextY.width - 25, nextY.height);
            dropdown.getEntries().addAll(SortBy.values());
            dropdown.tooltipProperty().set(__ -> TTooltip.of((class_2561)BSSLang.gui_statsview_filter_sortBy()), SortBy.class);
            panel.add((Node)dropdown);
            dropdown.selectedEntryProperty().set((Object)((SortBy)context.getFilters().getProperty(SortBy.class, FID, VANILLA)), SortBy.class);
            dropdown.selectedEntryProperty().addChangeListener((p, o, n) -> context.getFilters().setProperty(SortBy.class, FID, n));
        }

        @NotNull
        public static final Collection<SortBy> values() {
            List ist = IStatsProvider.getEntityStatTypes();
            ArrayList<SortBy> list = new ArrayList<SortBy>(2 + ist.size());
            list.add(VANILLA);
            list.add(ALPHABETICAL);
            list.add(LACITEBAHPLA);
            for (class_3448 statType : ist) {
                list.add(new SortBy(statType, IStatsProvider.getStatTypeName((class_3448)statType), Comparator.comparing(s -> s.getStatsProvider().getIntValue(statType, (Object)((class_1299)s.getSubject())))));
            }
            return list;
        }
    }

    public static final class GroupBy
    extends Enum<GroupBy>
    implements TDropdownWidget.Entry {
        public static final /* enum */ GroupBy ALL = new GroupBy((class_2561)BSSLang.gui_statsview_filter_groupBy_all(), stats -> {
            LinkedHashMap<class_5250, Iterable> map = new LinkedHashMap<class_5250, Iterable>();
            map.put(class_2561.method_43470((String)"*"), (Iterable)stats);
            return map;
        });
        public static final /* enum */ GroupBy MOD = new GroupBy((class_2561)class_2561.method_43470((String)"Mod"), stats -> {
            LinkedHashMap<String, ArrayList> map = new LinkedHashMap<String, ArrayList>();
            for (EntityStats stat : stats) {
                map.computeIfAbsent(stat.getSubjectID().method_12836(), __ -> new ArrayList()).add(stat);
            }
            return map.entrySet().stream().collect(Collectors.toMap(entry -> {
                assert (ModInfoProvider.getInstance() != null);
                return ModInfoProvider.getInstance().getModInfo((String)entry.getKey()).getName();
            }, Map.Entry::getValue, (existing, replacement) -> existing, LinkedHashMap::new));
        });
        public static final /* enum */ GroupBy CATEGORY = new GroupBy((class_2561)BSSLang.gui_statsview_filter_groupBy_mobCategory(), stats -> {
            LinkedHashMap<class_1311, ArrayList> map = new LinkedHashMap<class_1311, ArrayList>();
            for (EntityStats stat : stats) {
                class_1311 category = ((class_1299)stat.getSubject()).method_5891();
                map.computeIfAbsent(category, __ -> new ArrayList()).add(stat);
            }
            return map.entrySet().stream().collect(Collectors.toMap(entry -> class_2561.method_43471((String)("mobCategory." + ((class_1311)entry.getKey()).method_6133())), Map.Entry::getValue, (existing, replacement) -> existing, LinkedHashMap::new));
        });
        public static final class_2960 FID;
        @NotNull
        private final class_2561 name;
        @NotNull
        private final Function<Iterable<EntityStats>, LinkedHashMap<class_2561, Iterable<EntityStats>>> grouper;
        private static final /* synthetic */ GroupBy[] $VALUES;

        public static GroupBy[] values() {
            return (GroupBy[])$VALUES.clone();
        }

        public static GroupBy valueOf(String name) {
            return Enum.valueOf(GroupBy.class, name);
        }

        private GroupBy(class_2561 name, Function<Iterable<EntityStats>, LinkedHashMap<class_2561, Iterable<EntityStats>>> grouper) {
            this.name = Objects.requireNonNull(name);
            this.grouper = grouper;
        }

        @NotNull
        public final class_2561 getDisplayName() {
            return this.name;
        }

        @NotNull
        public final Function<Iterable<EntityStats>, LinkedHashMap<class_2561, Iterable<EntityStats>>> getStatsGrouper() {
            return this.grouper;
        }

        public static final void initFilter(@NotNull StatsView.FiltersInitContext context) throws NullPointerException {
            TPanelElement panel = context.getPanel();
            Bounds2i nextY = panel.computeNextYBounds(20, 3);
            TTextureElement icon = new TTextureElement(BSSSprites.gui_icon_filterGroup());
            icon.setBounds(nextY.x, nextY.y, 20, nextY.height);
            panel.add((Node)icon);
            TDropdownWidget dropdown = new TDropdownWidget();
            dropdown.setBounds(nextY.x + 25, nextY.y, nextY.width - 25, nextY.height);
            Collections.addAll(dropdown.getEntries(), GroupBy.values());
            dropdown.tooltipProperty().set(__ -> TTooltip.of((class_2561)BSSLang.gui_statsview_filter_groupBy()), GroupBy.class);
            panel.add((Node)dropdown);
            dropdown.selectedEntryProperty().set((Object)((GroupBy)((Object)context.getFilters().getProperty(GroupBy.class, FID, (Object)MOD))), GroupBy.class);
            dropdown.selectedEntryProperty().addChangeListener((p, o, n) -> context.getFilters().setProperty(GroupBy.class, FID, n));
        }

        private static /* synthetic */ GroupBy[] $values() {
            return new GroupBy[]{ALL, MOD, CATEGORY};
        }

        static {
            $VALUES = GroupBy.$values();
            FID = class_2960.method_60655((String)"betterstats", (String)"entities_group_by");
        }
    }
}

