/*
 * Decompiled with CFR 0.152.
 */
package fuzs.deleteworldstotrash.client.handler;

import com.google.common.collect.ImmutableList;
import fuzs.deleteworldstotrash.DeleteWorldsToTrash;
import fuzs.deleteworldstotrash.client.recycler.DesktopRecycler;
import fuzs.deleteworldstotrash.client.recycler.FileUtilsRecycler;
import fuzs.deleteworldstotrash.client.recycler.WorldRecycler;
import fuzs.deleteworldstotrash.services.CommonAbstractions;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_370;
import net.minecraft.class_5125;

public class WorldTrashHandler {
    private static final int MAX_DELETE_WORLD_ATTEMPTS = 5;
    private static final List<WorldRecycler> SYSTEM_RECYCLERS = CommonAbstractions.INSTANCE.getModLoader() == CommonAbstractions.ModLoader.NEOFORGE ? ImmutableList.of((Object)FileUtilsRecycler.INSTANCE) : ImmutableList.of((Object)FileUtilsRecycler.INSTANCE, (Object)DesktopRecycler.INSTANCE);

    public static boolean tryMoveToTrash(class_5125 lock, Path levelPath, String levelId) {
        for (WorldRecycler recycler : SYSTEM_RECYCLERS) {
            if (!recycler.isSupported()) continue;
            for (int i = 0; i < 5; ++i) {
                DeleteWorldsToTrash.LOGGER.info("Attempt {} moving {} to trash using {}", new Object[]{i + 1, levelId, recycler.getName()});
                try {
                    lock.close();
                    if (!recycler.moveToTrash(levelPath.toFile())) continue;
                    return true;
                }
                catch (Throwable throwable) {
                    DeleteWorldsToTrash.LOGGER.warn("Failed to delete {}", (Object)levelPath, (Object)throwable);
                }
            }
        }
        class_370.method_27025((class_310)class_310.method_1551(), (String)levelId);
        return false;
    }

    public static boolean isTrashSupported() {
        for (WorldRecycler worldRecycler : SYSTEM_RECYCLERS) {
            if (!worldRecycler.isSupported()) continue;
            return true;
        }
        return false;
    }
}

