/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.common.gui;

import betteradvancements.common.gui.BetterAdvancementTab;
import betteradvancements.common.gui.BetterAdvancementTabType;
import betteradvancements.common.gui.BetterAdvancementWidget;
import betteradvancements.common.platform.Services;
import betteradvancements.common.reference.Resources;
import betteradvancements.common.util.RenderUtil;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_167;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2859;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_632;
import net.minecraft.class_634;
import net.minecraft.class_8779;
import net.minecraft.class_8781;

public class BetterAdvancementsScreen
extends class_437
implements class_632.class_633 {
    private static final class_2561 VERY_SAD_LABEL = class_2561.method_43471((String)"advancements.sad_label");
    private static final class_2561 NO_ADVANCEMENTS_LABEL = class_2561.method_43471((String)"advancements.empty");
    private static final class_2561 TITLE = class_2561.method_43471((String)"gui.advancements");
    private static final int WIDTH = 252;
    private static final int HEIGHT = 140;
    private static final int CORNER_SIZE = 30;
    private static final int SIDE = 30;
    private static final int TOP = 40;
    private static final int BOTTOM = 30;
    private static final int PADDING = 9;
    public static final float MIN_ZOOM = 0.4f;
    public static final float MAX_ZOOM = 1.6f;
    public static final float ZOOM_STEP = 0.1f;
    private final class_632 clientAdvancements;
    private final Map<class_8779, BetterAdvancementTab> tabs = Maps.newLinkedHashMap();
    private BetterAdvancementTab selectedTab;
    private static int tabPage;
    private static int maxPages;
    public static float zoom;
    private boolean isScrolling;
    protected int internalWidth;
    protected int internalHeight;
    public static int uiScaling;
    public static boolean showDebugCoordinates;
    public static boolean orderTabsAlphabetically;
    public static boolean keepAdvancementsTitle;
    private BetterAdvancementWidget advConnectedToMouse = null;

    public BetterAdvancementsScreen(class_632 clientAdvancements) {
        super(class_333.field_18967);
        this.clientAdvancements = clientAdvancements;
    }

    protected void method_25426() {
        this.internalHeight = this.field_22790 * uiScaling / 100;
        this.internalWidth = this.field_22789 * uiScaling / 100;
        this.tabs.clear();
        this.selectedTab = null;
        this.clientAdvancements.method_2862((class_632.class_633)this);
        if (this.selectedTab == null && !this.tabs.isEmpty()) {
            BetterAdvancementTab advancementTab = this.tabs.values().iterator().next();
            this.clientAdvancements.method_2864(advancementTab.getRootNode().method_53649(), true);
        } else {
            this.clientAdvancements.method_2864(this.selectedTab == null ? null : this.selectedTab.getRootNode().method_53649(), true);
        }
        int left = 30 + (this.field_22789 - this.internalWidth) / 2;
        int top = 40 + (this.field_22790 - this.internalHeight) / 2;
        int right = this.internalWidth - 30 + (this.field_22789 - this.internalWidth) / 2;
        int bottom = this.internalHeight - 30 + (this.field_22790 - this.internalHeight) / 2;
        int width = right - left;
        int height = bottom - top;
        int maxTabs = BetterAdvancementTabType.getMaxTabs(width, height);
        if (this.tabs.size() > maxTabs) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"<"), b -> {
                tabPage = Math.max(tabPage - 1, 0);
            }).method_46433(left, bottom + 4).method_46437(20, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)">"), b -> {
                tabPage = Math.min(tabPage + 1, maxPages);
            }).method_46433(right - 20, bottom + 4).method_46437(20, 20).method_46431());
            maxPages = this.tabs.size() / maxTabs;
            tabPage = Math.min(tabPage, maxPages);
        }
    }

    public void method_25419() {
        this.clientAdvancements.method_2862(null);
        class_634 clientpacketlistener = this.field_22787.method_1562();
        if (clientpacketlistener != null) {
            clientpacketlistener.method_52787((class_2596)class_2859.method_12414());
        }
        super.method_25419();
    }

    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        if (event.comp_4797() == 0) {
            int left = 30 + (this.field_22789 - this.internalWidth) / 2;
            int top = 40 + (this.field_22790 - this.internalHeight) / 2;
            int right = this.internalWidth - 30 + (this.field_22789 - this.internalWidth) / 2;
            int bottom = this.internalHeight - 30 + (this.field_22790 - this.internalHeight) / 2;
            int width = right - left;
            int height = bottom - top;
            int maxTabs = BetterAdvancementTabType.getMaxTabs(width, height);
            int skip = tabPage * maxTabs;
            for (BetterAdvancementTab tab : this.tabs.values().stream().skip(skip).limit(maxTabs).toList()) {
                if (!tab.isMouseOver(left, top, this.internalWidth - 60, this.internalHeight - top - 30, event.comp_4798(), event.comp_4799())) continue;
                this.clientAdvancements.method_2864(tab.getRootNode().method_53649(), true);
                break;
            }
        }
        return super.method_25402(event, isDoubleClick);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.selectedTab != null) {
            if (this.field_22787.method_74188()) {
                zoom += scrollY > 0.0 ? 0.1f : -0.1f;
                zoom = Math.max(0.4f, Math.min(zoom, 1.6f));
            } else {
                this.selectedTab.scroll(scrollX * 16.0, scrollY * 16.0, this.internalWidth - 60 - 27, this.internalHeight - 40 - 30 - 27);
            }
            return true;
        }
        return false;
    }

    public boolean method_25404(class_11908 event) {
        if (this.field_22787.field_1690.field_1844.method_1417(event)) {
            this.field_22787.method_1507(null);
            this.field_22787.field_1729.method_1612();
            return true;
        }
        return super.method_25404(event);
    }

    public boolean method_25403(class_11909 event, double mouseDeltaX, double mouseDeltaY) {
        int left = 30 + (this.field_22789 - this.internalWidth) / 2;
        int top = 40 + (this.field_22790 - this.internalHeight) / 2;
        if (event.method_74245() != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            if (this.advConnectedToMouse == null) {
                boolean inGui;
                boolean bl = inGui = event.comp_4798() < (double)(left + this.internalWidth - 60 - 9) && event.comp_4798() > (double)(left + 9) && event.comp_4799() < (double)(top + this.internalHeight - 40 + 1) && event.comp_4799() > (double)(top + 18);
                if (this.selectedTab != null && inGui) {
                    for (BetterAdvancementWidget betterAdvancementEntryScreen : this.selectedTab.widgets.values()) {
                        if (!betterAdvancementEntryScreen.isMouseOver(this.selectedTab.scrollX, this.selectedTab.scrollY, event.comp_4798() - (double)left - 9.0, event.comp_4799() - (double)top - 18.0, zoom) || !betterAdvancementEntryScreen.betterDisplayInfo.allowDragging()) continue;
                        this.advConnectedToMouse = betterAdvancementEntryScreen;
                        break;
                    }
                }
            } else {
                this.advConnectedToMouse.x = (int)Math.round((double)this.advConnectedToMouse.x + mouseDeltaX);
                this.advConnectedToMouse.y = (int)Math.round((double)this.advConnectedToMouse.y + mouseDeltaY);
            }
        } else {
            if (this.advConnectedToMouse != null) {
                Services.PLATFORM.getEventHelper().postAdvancementMovementEvent(this.advConnectedToMouse);
            }
            this.advConnectedToMouse = null;
        }
        if (this.advConnectedToMouse == null) {
            if (!this.isScrolling) {
                this.isScrolling = true;
            } else if (this.selectedTab != null) {
                this.selectedTab.scroll(mouseDeltaX, mouseDeltaY, this.internalWidth - 60 - 27, this.internalHeight - 40 - 30 - 27);
            }
        }
        return true;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int left = 30 + (this.field_22789 - this.internalWidth) / 2;
        int top = 40 + (this.field_22790 - this.internalHeight) / 2;
        int right = this.internalWidth - 30 + (this.field_22789 - this.internalWidth) / 2;
        int bottom = this.internalHeight - 30 + (this.field_22790 - this.internalHeight) / 2;
        int width = right - left;
        int height = bottom - top;
        int maxTabs = BetterAdvancementTabType.getMaxTabs(width, height);
        int skip = tabPage * maxTabs;
        if (maxPages != 0) {
            class_5250 page = class_2561.method_43470((String)String.format("%d / %d", tabPage + 1, maxPages + 1));
            int textWidth = this.field_22793.method_27525((class_5348)page);
            guiGraphics.method_35720(this.field_22793, page.method_30937(), left + (this.internalWidth - textWidth) / 2 - textWidth, bottom + 8, -1);
            super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
        guiGraphics.method_71048();
        this.renderInside(guiGraphics, mouseX, mouseY, left, top, right, bottom, maxTabs, skip);
        guiGraphics.method_71048();
        this.renderWindow(guiGraphics, left, top, right, bottom, maxTabs, skip);
        if (this.advConnectedToMouse == null) {
            this.renderToolTips(guiGraphics, mouseX, mouseY, left, top, right, bottom, maxTabs, skip);
        }
        if (this.advConnectedToMouse != null) {
            for (BetterAdvancementWidget betterAdvancementEntryScreen : this.selectedTab.widgets.values()) {
                if (betterAdvancementEntryScreen == this.advConnectedToMouse) continue;
                int x1 = betterAdvancementEntryScreen.x + left + 9 + this.selectedTab.scrollX + 3;
                int x2 = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3;
                int y1 = betterAdvancementEntryScreen.y + top + 18 + this.selectedTab.scrollY;
                int y2 = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY;
                int centerX1 = betterAdvancementEntryScreen.x + left + 9 + this.selectedTab.scrollX + 3 + 13;
                int centerX2 = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3 + 13;
                int centerY1 = betterAdvancementEntryScreen.y + top + 18 + this.selectedTab.scrollY + 13;
                int centerY2 = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY + 13;
                double degrees = Math.toDegrees(Math.atan2(centerX1 - centerX2, centerY1 - centerY2));
                if (degrees < 0.0) {
                    degrees += 360.0;
                }
                if (betterAdvancementEntryScreen.x == this.advConnectedToMouse.x) {
                    if (y1 > y2) {
                        RenderUtil.drawRect(guiGraphics, x1, y1 + 26 - 1, x2, y2, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1 + 26 - 1, x2, y1 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1, x2, y1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y2 + 26 - 1, x2, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y2, x2, y2, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1 + 26 - 1, x2 + 26 - 1, y2, 1.0f, 65280);
                    } else {
                        RenderUtil.drawRect(guiGraphics, x1, y2 + 26 - 1, x2, y1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y2 + 26 - 1, x2, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y2, x2, y2, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1 + 26 - 1, x2, y1 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1, x2, y1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y2 + 26 - 1, x2 + 26 - 1, y1, 1.0f, 65280);
                    }
                }
                if (betterAdvancementEntryScreen.y == this.advConnectedToMouse.y) {
                    if (x1 > x2) {
                        RenderUtil.drawRect(guiGraphics, x2, y1, x1 + 26 - 1, y2, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1, y1, x1, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1, x1 + 26 - 1, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x2, y1, x2, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x2 + 26 - 1, y1, x2 + 26 - 1, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x2, y1 + 26 - 1, x1 + 26 - 1, y2 + 26 - 1, 1.0f, 65280);
                    } else {
                        RenderUtil.drawRect(guiGraphics, x2 + 26 - 1, y1, x1, y2, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x2, y1, x2, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x2 + 26 - 1, y1, x2 + 26 - 1, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1, y1, x1, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1, x1 + 26 - 1, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x2 + 26 - 1, y1 + 26 - 1, x1, y2 + 26 - 1, 1.0f, 65280);
                    }
                }
                if (degrees != 45.0 && degrees != 135.0 && degrees != 225.0 && degrees != 315.0) continue;
                RenderUtil.drawRect(guiGraphics, x1, y1, x1 + 26 - 1, y1, 1.0f, 65280);
                RenderUtil.drawRect(guiGraphics, x1, y1 + 26 - 1, x1 + 26 - 1, y1 + 26 - 1, 1.0f, 65280);
                RenderUtil.drawRect(guiGraphics, x1, y1, x1, y1 + 26 - 1, 1.0f, 65280);
                RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1, x1 + 26 - 1, y1 + 26 - 1, 1.0f, 65280);
                RenderUtil.drawRect(guiGraphics, x2, y2, x2 + 26 - 1, y2, 1.0f, 65280);
                RenderUtil.drawRect(guiGraphics, x2, y2 + 26 - 1, x2 + 26 - 1, y2 + 26 - 1, 1.0f, 65280);
                RenderUtil.drawRect(guiGraphics, x2, y2, x2, y2 + 26 - 1, 1.0f, 65280);
                RenderUtil.drawRect(guiGraphics, x2 + 26 - 1, y2, x2 + 26 - 1, y2 + 26 - 1, 1.0f, 65280);
                if (degrees == 45.0 || degrees == 225.0) {
                    RenderUtil.drawRect(guiGraphics, x1, y1 + 26 - 1, x2, y2 + 26 - 1, 1.0f, 65280);
                    RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1, x2 + 26 - 1, y2, 1.0f, 65280);
                    continue;
                }
                if (degrees != 135.0 && degrees != 315.0) continue;
                RenderUtil.drawRect(guiGraphics, x1, y1, x2, y2, 1.0f, 65280);
                RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1 + 26 - 1, x2 + 26 - 1, y2 + 26 - 1, 1.0f, 65280);
            }
        }
        if (showDebugCoordinates && this.selectedTab != null && mouseX < this.internalWidth - 30 - 9 && mouseX > 39 && mouseY < this.internalHeight - top + 1 && mouseY > top + 18) {
            if (this.advConnectedToMouse != null) {
                int currentX = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3 + 1;
                int n = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY;
                Objects.requireNonNull(this.field_22793);
                int currentY = n - 9 + 1;
                guiGraphics.method_25303(this.field_22793, this.advConnectedToMouse.x + "," + this.advConnectedToMouse.y, currentX, currentY, 0);
            } else {
                int xMouse = mouseX - left - 9;
                int yMouse = mouseY - top - 18;
                int currentX = xMouse - this.selectedTab.scrollX - 3 - 1;
                int currentY = yMouse - this.selectedTab.scrollY - 1;
                String string = currentX + "," + currentY;
                Objects.requireNonNull(this.field_22793);
                guiGraphics.method_25303(this.field_22793, string, mouseX, mouseY - 9, 0);
            }
        }
    }

    private void renderInside(class_332 guiGraphics, int mouseX, int mouseY, int left, int top, int right, int bottom, int maxTabs, int skip) {
        BetterAdvancementTab betterAdvancementTab = this.selectedTab;
        int boxLeft = left + 9;
        int boxTop = top + 18;
        int boxRight = right - 9;
        int boxBottom = bottom - 9;
        int width = boxRight - boxLeft;
        int height = boxBottom - boxTop;
        if (betterAdvancementTab == null) {
            guiGraphics.method_25294(boxLeft, boxTop, boxRight, boxBottom, -16777216);
            int n = boxLeft + (width - this.field_22793.method_27525((class_5348)NO_ADVANCEMENTS_LABEL)) / 2;
            int n2 = boxTop + height / 2;
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_27535(this.field_22793, NO_ADVANCEMENTS_LABEL, n, n2 - 9, -1);
            int n3 = boxLeft + (width - this.field_22793.method_27525((class_5348)VERY_SAD_LABEL)) / 2;
            int n4 = boxTop + height / 2;
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_27535(this.field_22793, VERY_SAD_LABEL, n3, n4 + 9, -1);
        } else {
            betterAdvancementTab.drawContents(guiGraphics, boxLeft, boxTop, width, height, zoom);
        }
    }

    public void renderWindow(class_332 guiGraphics, int left, int top, int right, int bottom, int maxTabs, int skip) {
        guiGraphics.method_25290(class_10799.field_56883, Resources.Gui.WINDOW, left, top, 0.0f, 0.0f, 30, 30, 256, 256);
        RenderUtil.renderRepeating(Resources.Gui.WINDOW, guiGraphics, left + 30, top, this.internalWidth - 30 - 60 - 30, 30, 30, 0, 192, 30);
        guiGraphics.method_25290(class_10799.field_56883, Resources.Gui.WINDOW, right - 30, top, 222.0f, 0.0f, 30, 30, 256, 256);
        RenderUtil.renderRepeating(Resources.Gui.WINDOW, guiGraphics, left, top + 30, 30, bottom - top - 60, 0, 30, 30, 80);
        RenderUtil.renderRepeating(Resources.Gui.WINDOW, guiGraphics, right - 30, top + 30, 30, bottom - top - 60, 222, 30, 30, 80);
        guiGraphics.method_25290(class_10799.field_56883, Resources.Gui.WINDOW, left, bottom - 30, 0.0f, 110.0f, 30, 30, 256, 256);
        RenderUtil.renderRepeating(Resources.Gui.WINDOW, guiGraphics, left + 30, bottom - 30, this.internalWidth - 30 - 60 - 30, 30, 30, 110, 192, 30);
        guiGraphics.method_25290(class_10799.field_56883, Resources.Gui.WINDOW, right - 30, bottom - 30, 222.0f, 110.0f, 30, 30, 256, 256);
        int width = right - left;
        int height = bottom - top;
        if (this.tabs.size() > 1) {
            for (BetterAdvancementTab tab : this.tabs.values().stream().skip(skip).limit(maxTabs).toList()) {
                tab.drawTab(guiGraphics, left, top, width, height, tab == this.selectedTab);
            }
            for (BetterAdvancementTab tab : this.tabs.values().stream().skip(skip).limit(maxTabs).toList()) {
                tab.drawIcon(guiGraphics, left, top, width, height);
            }
        }
        class_5481 windowTitle = TITLE.method_30937();
        if (this.selectedTab != null) {
            windowTitle = keepAdvancementsTitle ? class_5481.method_34909((class_5481[])new class_5481[]{windowTitle, class_2561.method_48321((String)"betteradvancements.title_separator", (String)" - ").method_30937(), this.selectedTab.getTitle().method_30937()}) : this.selectedTab.getTitle().method_30937();
        }
        guiGraphics.method_51430(this.field_22793, windowTitle, left + 8, top + 6, -12566464, false);
    }

    private void renderToolTips(class_332 guiGraphics, int mouseX, int mouseY, int left, int top, int right, int bottom, int maxTabs, int skip) {
        if (this.selectedTab != null) {
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().translate((float)(left + 9), (float)(top + 18));
            this.selectedTab.drawToolTips(guiGraphics, mouseX - left - 9, mouseY - top - 18, left, top, right - left - 18, bottom - top - 27, zoom);
            guiGraphics.method_51448().popMatrix();
        }
        int width = right - left;
        int height = bottom - top;
        if (this.tabs.size() > 1) {
            for (BetterAdvancementTab tab : this.tabs.values().stream().skip(skip).limit(maxTabs).toList()) {
                if (!tab.isMouseOver(left, top, width, height, mouseX, mouseY)) continue;
                guiGraphics.method_51438(this.field_22793, tab.getTitle(), mouseX, mouseY);
            }
        }
    }

    public void method_723(class_8781 advancement) {
        BetterAdvancementTab betterAdvancementTabGui = BetterAdvancementTab.create(this.field_22787, this, this.tabs.size(), advancement, this.internalWidth - 60, this.internalHeight - 40 - 30);
        if (betterAdvancementTabGui != null) {
            this.tabs.put(advancement.method_53649(), betterAdvancementTabGui);
        }
    }

    public void method_720(class_8781 advancement) {
    }

    public void method_721(class_8781 advancement) {
        BetterAdvancementTab betterAdvancementTabGui = this.getTab(advancement);
        if (betterAdvancementTabGui != null) {
            betterAdvancementTabGui.addAdvancement(advancement);
        }
    }

    public void method_719(class_8781 advancement) {
    }

    public void method_2865(class_8781 advancement, class_167 advancementProgress) {
        BetterAdvancementWidget betterAdvancementEntryScreen = this.getAdvancementWidget(advancement);
        if (betterAdvancementEntryScreen != null) {
            betterAdvancementEntryScreen.getAdvancementProgress(advancementProgress);
        }
    }

    public void method_2866(class_8779 advancement) {
        if (this.selectedTab != null) {
            this.selectedTab.storeScroll();
        }
        this.selectedTab = this.tabs.get(advancement);
        if (this.selectedTab != null) {
            this.selectedTab.loadScroll(this.internalWidth - 60 - 27, this.internalHeight - 40 - 30 - 27);
        }
    }

    public void method_722() {
        this.tabs.clear();
        this.selectedTab = null;
    }

    public BetterAdvancementWidget getAdvancementWidget(class_8781 advancement) {
        BetterAdvancementTab betterAdvancementTab = this.getTab(advancement);
        return betterAdvancementTab == null ? null : betterAdvancementTab.getWidget(advancement.method_53649());
    }

    private BetterAdvancementTab getTab(class_8781 advancement) {
        class_8781 advancementNode = advancement.method_53652();
        return this.tabs.get(advancementNode.method_53649());
    }

    static {
        zoom = 1.0f;
        uiScaling = 100;
        showDebugCoordinates = false;
        orderTabsAlphabetically = false;
        keepAdvancementsTitle = true;
    }
}

