/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.world;

import fi.dy.masa.tweakeroo.world.FakeChunk;
import fi.dy.masa.tweakeroo.world.FakeWorld;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1923;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3568;

public class FakeChunkManager
extends class_2802 {
    private final FakeWorld world;
    private final FakeChunk blankChunk;
    private FakeChunkMap chunks;

    public FakeChunkManager(FakeWorld world, int loadDistance) {
        this.world = world;
        this.blankChunk = new FakeChunk(world, new class_1923(0, 0));
        this.chunks = new FakeChunkMap(FakeChunkManager.getChunkMapRadius(loadDistance));
    }

    @Nonnull
    public FakeWorld getLevel() {
        return this.world;
    }

    public void loadChunk(int chunkX, int chunkZ) {
        FakeChunk chunk = new FakeChunk(this.world, new class_1923(chunkX, chunkZ));
        this.chunks.set(chunkX, chunkZ, chunk);
    }

    public boolean method_12123(int chunkX, int chunkZ) {
        return this.chunks.get(chunkX, chunkZ) != null;
    }

    @Nonnull
    public String method_12122() {
        return "Fake Chunk Cache: " + this.method_14151();
    }

    public int method_14151() {
        return 1;
    }

    public class_2818 getChunk(int chunkX, int chunkZ, @Nonnull class_2806 status, boolean fallbackToEmpty) {
        FakeChunk chunk = this.getChunkForLighting(chunkX, chunkZ);
        return chunk == null && fallbackToEmpty ? this.blankChunk : chunk;
    }

    public FakeChunk getChunkForLighting(int chunkX, int chunkZ) {
        FakeChunk chunk = this.chunks.get(chunkX, chunkZ);
        return chunk == null ? this.blankChunk : chunk;
    }

    @Nullable
    public FakeChunk getChunkIfExists(int chunkX, int chunkZ) {
        return this.chunks.get(chunkX, chunkZ);
    }

    public void unloadChunk(int chunkX, int chunkZ) {
        this.chunks.set(chunkX, chunkZ, null);
    }

    public class_3568 method_12130() {
        return null;
    }

    public void setChunkMapCenter(int x, int z) {
        this.chunks.centerChunkX = x;
        this.chunks.centerChunkZ = z;
    }

    public class_1923 getChunkMapCenter() {
        return new class_1923(this.chunks.centerChunkX, this.chunks.centerChunkZ);
    }

    public int getRadius() {
        return this.chunks.radius;
    }

    public void updateLoadDistance(int loadDistance) {
        int i = this.chunks.radius;
        int j = FakeChunkManager.getChunkMapRadius(loadDistance);
        if (i != j) {
            FakeChunkMap newChunkMap = new FakeChunkMap(j);
            newChunkMap.centerChunkX = this.chunks.centerChunkX;
            newChunkMap.centerChunkZ = this.chunks.centerChunkZ;
            for (int k = 0; k < this.chunks.chunks.length(); ++k) {
                FakeChunk chunk = this.chunks.chunks.get(k);
                if (chunk == null) continue;
                class_1923 chunkPos = chunk.method_12004();
                newChunkMap.set(chunkPos.field_9181, chunkPos.field_9180, chunk);
            }
            this.chunks = newChunkMap;
        }
    }

    private static int getChunkMapRadius(int loadDistance) {
        return Math.max(2, loadDistance) + 3;
    }

    public void method_12127(@Nonnull BooleanSupplier var1, boolean var2) {
    }

    private static final class FakeChunkMap {
        final AtomicReferenceArray<FakeChunk> chunks;
        final int radius;
        private final int diameter;
        volatile int centerChunkX;
        volatile int centerChunkZ;

        FakeChunkMap(int radius) {
            this.radius = radius;
            this.diameter = radius * 2 + 1;
            this.chunks = new AtomicReferenceArray(this.diameter * this.diameter);
        }

        int getIndex(int chunkX, int chunkZ) {
            return Math.floorMod(chunkZ, this.diameter) * this.diameter + Math.floorMod(chunkX, this.diameter);
        }

        private void set(int x, int z, @Nullable FakeChunk chunk) {
            if (this.isInRadius(x, z)) {
                this.chunks.set(this.getIndex(x, z), chunk);
            }
        }

        private FakeChunk get(int x, int z) {
            if (!this.isInRadius(x, z)) {
                return null;
            }
            FakeChunk chunk = this.chunks.get(this.getIndex(x, z));
            if (chunk == null) {
                return null;
            }
            if (!FakeChunkMap.positionEquals(chunk, x, z)) {
                return null;
            }
            return chunk;
        }

        boolean isInRadius(int chunkX, int chunkZ) {
            return Math.abs(chunkX - this.centerChunkX) <= this.radius && Math.abs(chunkZ - this.centerChunkZ) <= this.radius;
        }

        private static boolean positionEquals(@Nullable class_2818 chunk, int x, int z) {
            if (chunk == null) {
                return false;
            }
            class_1923 chunkPos = chunk.method_12004();
            return chunkPos.field_9181 == x && chunkPos.field_9180 == z;
        }
    }
}

