/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.CarpetSettings;
import carpet.fakes.LevelInterface;
import carpet.utils.SpawnReporter;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1315;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_238;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1948.class})
public class NaturalSpawnerMixin {
    @Shadow
    @Final
    private static int field_24392;
    @Shadow
    @Final
    private static class_1311[] field_24393;

    @Redirect(method={"method_24934(Lnet/minecraft/class_3218;Lnet/minecraft/class_1311;Lnet/minecraft/class_5138;Lnet/minecraft/class_2794;Lnet/minecraft/class_5483$class_1964;Lnet/minecraft/class_2338$class_2339;D)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3218;method_18026(Lnet/minecraft/class_238;)Z"))
    private static boolean doesNotCollide(class_3218 world, class_238 bb) {
        int z;
        int x;
        if (!CarpetSettings.lagFreeSpawning) {
            return world.method_18026(bb);
        }
        int minX = class_3532.method_15357((double)bb.field_1323);
        int minY = class_3532.method_15357((double)bb.field_1322);
        int minZ = class_3532.method_15357((double)bb.field_1321);
        int maxY = class_3532.method_15384((double)bb.field_1325) - 1;
        class_2338.class_2339 blockpos = new class_2338.class_2339();
        if (bb.method_17939() <= 1.0) {
            for (int y = minY; y <= maxY; ++y) {
                blockpos.method_10103(minX, y, minZ);
                class_265 box = world.method_8320((class_2338)blockpos).method_26220((class_1922)world, (class_2338)blockpos);
                if (box == class_259.method_1073()) continue;
                if (box == class_259.method_1077()) {
                    return false;
                }
                return world.method_18026(bb);
            }
            return true;
        }
        int maxX = class_3532.method_15384((double)bb.field_1320) - 1;
        int maxZ = class_3532.method_15384((double)bb.field_1324) - 1;
        for (int y = minY; y <= maxY; ++y) {
            for (x = minX; x <= maxX; ++x) {
                for (z = minZ; z <= maxZ; ++z) {
                    blockpos.method_10103(x, y, z);
                    class_265 box = world.method_8320((class_2338)blockpos).method_26220((class_1922)world, (class_2338)blockpos);
                    if (box == class_259.method_1073()) continue;
                    if (box == class_259.method_1077()) {
                        return false;
                    }
                    return world.method_18026(bb);
                }
            }
        }
        int min_below = minY - 1;
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                blockpos.method_10103(x, min_below, z);
                class_2680 state = world.method_8320((class_2338)blockpos);
                class_2248 block = state.method_26204();
                if (!state.method_26164(class_3481.field_16584) && !state.method_26164(class_3481.field_15504) && (!(block instanceof class_2349) || ((Boolean)state.method_11654((class_2769)class_2349.field_11026)).booleanValue())) continue;
                if (x == minX || x == maxX || z == minZ || z == maxZ) {
                    return world.method_18026(bb);
                }
                return false;
            }
        }
        return true;
    }

    @Redirect(method={"method_24931(Lnet/minecraft/class_3218;Lnet/minecraft/class_1299;)Lnet/minecraft/class_1308;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_1299;method_5883(Lnet/minecraft/class_1937;Lnet/minecraft/class_3730;)Lnet/minecraft/class_1297;"))
    private static class_1297 create(class_1299 entityType, class_1937 world_1, class_3730 entitySpawnReason) {
        if (CarpetSettings.lagFreeSpawning) {
            Map<class_1299<?>, class_1297> precookedMobs = ((LevelInterface)world_1).getPrecookedMobs();
            if (precookedMobs.containsKey(entityType)) {
                return precookedMobs.get(entityType);
            }
            class_1297 e = entityType.method_5883(world_1, entitySpawnReason);
            precookedMobs.put(entityType, e);
            return e;
        }
        return entityType.method_5883(world_1, entitySpawnReason);
    }

    @Redirect(method={"method_24930(Lnet/minecraft/class_1311;Lnet/minecraft/class_3218;Lnet/minecraft/class_2791;Lnet/minecraft/class_2338;Lnet/minecraft/class_1948$class_5261;Lnet/minecraft/class_1948$class_5259;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3218;method_30771(Lnet/minecraft/class_1297;)V"))
    private static void spawnEntity(class_3218 world, class_1297 entity_1, class_1311 group, class_3218 world2, class_2791 chunk, class_2338 pos, class_1948.class_5261 checker, class_1948.class_5259 runner) {
        if (CarpetSettings.lagFreeSpawning) {
            ((LevelInterface)world).getPrecookedMobs().remove(entity_1.method_5864());
        }
        if (SpawnReporter.trackingSpawns() && SpawnReporter.local_spawns != null) {
            SpawnReporter.registerSpawn((class_1308)entity_1, group, entity_1.method_24515());
        }
        if (!SpawnReporter.mockSpawns) {
            world.method_30771(entity_1);
        }
    }

    @Redirect(method={"method_24930(Lnet/minecraft/class_1311;Lnet/minecraft/class_3218;Lnet/minecraft/class_2791;Lnet/minecraft/class_2338;Lnet/minecraft/class_1948$class_5261;Lnet/minecraft/class_1948$class_5259;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_1308;method_5943(Lnet/minecraft/class_5425;Lnet/minecraft/class_1266;Lnet/minecraft/class_3730;Lnet/minecraft/class_1315;)Lnet/minecraft/class_1315;"))
    private static class_1315 spawnEntity(class_1308 mobEntity, class_5425 serverWorldAccess, class_1266 difficulty, class_3730 spawnReason, class_1315 entityData) {
        if (!SpawnReporter.mockSpawns) {
            return mobEntity.method_5943(serverWorldAccess, difficulty, spawnReason, entityData);
        }
        return null;
    }

    @Redirect(method={"method_24930(Lnet/minecraft/class_1311;Lnet/minecraft/class_3218;Lnet/minecraft/class_2791;Lnet/minecraft/class_2338;Lnet/minecraft/class_1948$class_5261;Lnet/minecraft/class_1948$class_5259;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_1657;method_5649(DDD)D"))
    private static double getSqDistanceTo(class_1657 playerEntity, double double_1, double double_2, double double_3, class_1311 entityCategory, class_3218 serverWorld, class_2791 chunk, class_2338 blockPos) {
        double distanceTo = playerEntity.method_5649(double_1, double_2, double_3);
        if (CarpetSettings.lagFreeSpawning && distanceTo > 16384.0 && entityCategory != class_1311.field_6294) {
            return 0.0;
        }
        return distanceTo;
    }

    @Redirect(method={"method_27821(Lnet/minecraft/class_3218;Lnet/minecraft/class_2818;Lnet/minecraft/class_1948$class_5262;Ljava/util/List;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_1948;method_8663(Lnet/minecraft/class_1311;Lnet/minecraft/class_3218;Lnet/minecraft/class_2818;Lnet/minecraft/class_1948$class_5261;Lnet/minecraft/class_1948$class_5259;)V"))
    private static void spawnMultipleTimes(class_1311 category, class_3218 world, class_2818 chunk, class_1948.class_5261 checker, class_1948.class_5259 runner) {
        for (int i = 0; i < SpawnReporter.spawn_tries.get(category); ++i) {
            class_1948.method_8663((class_1311)category, (class_3218)world, (class_2818)chunk, (class_1948.class_5261)checker, (class_1948.class_5259)runner);
        }
    }

    @Inject(method={"method_27821(Lnet/minecraft/class_3218;Lnet/minecraft/class_2818;Lnet/minecraft/class_1948$class_5262;Ljava/util/List;)V"}, at={@At(value="HEAD")})
    private static void checkSpawns(class_3218 world, class_2818 chunk, class_1948.class_5262 info, List<class_1311> list, CallbackInfo ci) {
        if (SpawnReporter.trackingSpawns()) {
            for (class_1311 entityCategory : list) {
                class_5321 dim = world.method_27983();
                int newCap = entityCategory.method_6134();
                int int_2 = SpawnReporter.chunkCounts.get(dim);
                int int_3 = newCap * int_2 / field_24392;
                int mobCount = info.method_27830().getInt((Object)entityCategory);
                if (SpawnReporter.trackingSpawns() && !SpawnReporter.first_chunk_marker.contains(entityCategory)) {
                    SpawnReporter.first_chunk_marker.add(entityCategory);
                    Pair key = Pair.of((Object)dim, (Object)entityCategory);
                    int spawnTries = SpawnReporter.spawn_tries.get(entityCategory);
                    SpawnReporter.spawn_attempts.addTo((Object)key, (long)spawnTries);
                    SpawnReporter.spawn_cap_count.addTo((Object)key, (long)mobCount);
                }
                if (mobCount > int_3 && !SpawnReporter.mockSpawns) continue;
                SpawnReporter.local_spawns.putIfAbsent((Object)entityCategory, 0L);
            }
        }
    }
}

