/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.script.Expression;
import org.jspecify.annotations.Nullable;

public class Token
implements Comparable<Token> {
    public String surface = "";
    public String display = "";
    public String comment = "";
    public TokenType type;
    public int pos;
    public int ordinal = 0;
    public int linepos;
    public int lineno;
    public @Nullable Expression.ExpressionNode node = null;
    public static final Token NONE = new Token();

    public Token morphedInto(TokenType newType, String newSurface) {
        Token created = new Token();
        created.surface = newSurface;
        created.type = newType;
        created.pos = this.pos;
        created.linepos = this.linepos;
        created.lineno = this.lineno;
        created.node = this.node;
        created.ordinal = this.ordinal + 1;
        return created;
    }

    public void swapPlace(Token other) {
        int order = other.ordinal;
        other.ordinal = this.ordinal;
        this.ordinal = order;
    }

    public void morph(TokenType type, String s) {
        this.type = type;
        this.surface = s;
        this.display = "";
        this.comment = "";
    }

    public Token disguiseAs(@Nullable String s, @Nullable String s1) {
        if (s != null) {
            this.display = s;
        }
        if (s1 != null) {
            this.comment = s1;
        }
        return this;
    }

    public void append(char c) {
        this.surface = this.surface + c;
    }

    public void append(String s) {
        this.surface = this.surface + s;
    }

    public char charAt(int pos) {
        return this.surface.charAt(pos);
    }

    public int length() {
        return this.surface.length();
    }

    public String toString() {
        return this.surface;
    }

    @Override
    public int compareTo(Token o) {
        if (this.lineno != o.lineno) {
            return this.lineno - o.lineno;
        }
        if (this.linepos != o.linepos) {
            return this.linepos - o.linepos;
        }
        return this.ordinal - o.ordinal;
    }

    static enum TokenType {
        FUNCTION(true, false),
        OPERATOR(true, false),
        UNARY_OPERATOR(true, false),
        VARIABLE(false, false),
        CONSTANT(false, true),
        LITERAL(false, true),
        HEX_LITERAL(false, true),
        STRINGPARAM(false, true),
        OPEN_PAREN(false, true),
        COMMA(false, true),
        CLOSE_PAREN(false, true),
        MARKER(false, true);

        final boolean functional;
        final boolean constant;

        private TokenType(boolean functional, boolean constant) {
            this.functional = functional;
            this.constant = constant;
        }

        public boolean isFunctional() {
            return this.functional;
        }

        public boolean isConstant() {
            return this.constant;
        }
    }
}

