/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.annotation;

import carpet.script.Context;
import carpet.script.annotation.Param;
import carpet.script.annotation.ValueConverter;
import carpet.script.value.ListValue;
import carpet.script.value.Value;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;

final class ListConverter<T>
implements ValueConverter<List<T>> {
    private final ValueConverter<T> itemConverter;
    private final boolean allowSingletonCreation;

    @Override
    public String getTypeName() {
        return (String)(this.allowSingletonCreation ? this.itemConverter.getTypeName() + " or " : "") + "list of " + this.itemConverter.getTypeName() + "s";
    }

    @Override
    public @Nullable List<T> convert(Value value, @Nullable Context context) {
        return value instanceof ListValue ? this.convertListValue((ListValue)value, context) : (this.allowSingletonCreation ? this.convertSingleton(value, context) : null);
    }

    private @Nullable List<T> convertListValue(ListValue values, @Nullable Context context) {
        ArrayList<T> list = new ArrayList<T>(values.getItems().size());
        for (Value value : values) {
            T converted = this.itemConverter.convert(value, context);
            if (converted == null) {
                return null;
            }
            list.add(converted);
        }
        return list;
    }

    private @Nullable List<T> convertSingleton(Value val, @Nullable Context context) {
        T converted = this.itemConverter.convert(val, context);
        if (converted == null) {
            return null;
        }
        return Collections.singletonList(converted);
    }

    private ListConverter(AnnotatedType itemType, boolean allowSingletonCreation) {
        this.itemConverter = ValueConverter.fromAnnotatedType(itemType);
        this.allowSingletonCreation = allowSingletonCreation;
    }

    static ListConverter<?> fromAnnotatedType(AnnotatedType annotatedType) {
        AnnotatedParameterizedType paramType = (AnnotatedParameterizedType)annotatedType;
        AnnotatedType itemType = paramType.getAnnotatedActualTypeArguments()[0];
        boolean allowSingletonCreation = annotatedType.isAnnotationPresent(Param.AllowSingleton.class);
        return new ListConverter(itemType, allowSingletonCreation);
    }
}

