/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.annotation;

import carpet.script.Context;
import carpet.script.annotation.ListConverter;
import carpet.script.annotation.Param;
import carpet.script.annotation.ValueConverter;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.Value;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;

class MapConverter<K, V>
implements ValueConverter<Map<K, V>> {
    protected final ValueConverter<K> keyConverter;
    protected final ValueConverter<V> valueConverter;

    @Override
    public String getTypeName() {
        return "map with " + this.keyConverter.getTypeName() + "s as the key and " + this.valueConverter.getTypeName() + "s as the value";
    }

    @Override
    public Map<K, V> convert(Value value, @Nullable Context context) {
        HashMap<K, V> result = new HashMap<K, V>();
        if (value instanceof MapValue) {
            for (Map.Entry<Value, Value> entry : ((MapValue)value).getMap().entrySet()) {
                K key = this.keyConverter.convert(entry.getKey(), context);
                V val = this.valueConverter.convert(entry.getValue(), context);
                if (key == null || val == null) {
                    return null;
                }
                result.put(key, val);
            }
            return result;
        }
        return null;
    }

    private MapConverter(AnnotatedType keyType, AnnotatedType valueType) {
        this.keyConverter = ValueConverter.fromAnnotatedType(keyType);
        this.valueConverter = ValueConverter.fromAnnotatedType(valueType);
    }

    static MapConverter<?, ?> fromAnnotatedType(AnnotatedType annotatedType) {
        AnnotatedType[] annotatedGenerics = ((AnnotatedParameterizedType)annotatedType).getAnnotatedActualTypeArguments();
        return annotatedType.isAnnotationPresent(Param.KeyValuePairs.class) ? new PairConverter(annotatedGenerics[0], annotatedGenerics[1], annotatedType.getAnnotation(Param.KeyValuePairs.class)) : new MapConverter(annotatedGenerics[0], annotatedGenerics[1]);
    }

    private static final class PairConverter<K, V>
    extends MapConverter<K, V> {
        private final boolean acceptMultiParam;

        private PairConverter(AnnotatedType keyType, AnnotatedType valueType, Param.KeyValuePairs config) {
            super(keyType, valueType);
            this.acceptMultiParam = config.allowMultiparam();
        }

        @Override
        public boolean consumesVariableArgs() {
            return this.acceptMultiParam;
        }

        @Override
        public @Nullable Map<K, V> convert(Value value, @Nullable Context context) {
            return value instanceof MapValue ? super.convert(value, context) : (value instanceof ListValue ? this.convertList(((ListValue)value).getItems(), context) : null);
        }

        private @Nullable Map<K, V> convertList(List<Value> valueList, @Nullable Context context) {
            if (valueList.size() % 2 == 1) {
                return null;
            }
            HashMap map = new HashMap();
            Iterator<Value> val = valueList.iterator();
            while (val.hasNext()) {
                Object key = this.keyConverter.convert(val.next(), context);
                Object value = this.valueConverter.convert(val.next(), context);
                if (key == null || value == null) {
                    return null;
                }
                map.put(key, value);
            }
            return map;
        }

        @Override
        public @Nullable Map<K, V> checkAndConvert(Iterator<Value> valueIterator, Context context, Context.Type theLazyT) {
            if (!valueIterator.hasNext()) {
                return null;
            }
            Value val = valueIterator.next();
            if (!this.acceptMultiParam || val instanceof MapValue || val instanceof ListValue && !(this.keyConverter instanceof ListConverter)) {
                return this.convert(val, context);
            }
            HashMap map = new HashMap();
            Object key = this.keyConverter.convert(val, context);
            Object value = this.valueConverter.checkAndConvert(valueIterator, context, theLazyT);
            if (key == null || value == null) {
                return null;
            }
            map.put(key, value);
            while (valueIterator.hasNext()) {
                key = this.keyConverter.checkAndConvert(valueIterator, context, theLazyT);
                value = this.valueConverter.checkAndConvert(valueIterator, context, theLazyT);
                if (key == null || value == null) {
                    return null;
                }
                map.put(key, value);
            }
            return map;
        }

        @Override
        public String getTypeName() {
            return "either a map of key-value pairs" + (this.acceptMultiParam ? "," : " or") + " a list in the form of [key, value, key2, value2,...]" + (this.acceptMultiParam ? " or those key-value pairs in the function" : "") + " (keys being " + this.keyConverter.getTypeName() + "s and values being " + this.valueConverter.getTypeName() + "s)";
        }
    }
}

