/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.exception;

import carpet.script.exception.InternalExpressionException;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public class Throwables {
    private final String id;
    private final @Nullable Throwables parent;
    private static final Map<String, Throwables> byId = new HashMap<String, Throwables>();
    public static final Throwables THROWN_EXCEPTION_TYPE = Throwables.register("exception", null);
    public static final Throwables VALUE_EXCEPTION = Throwables.register("value_exception", THROWN_EXCEPTION_TYPE);
    public static final Throwables UNKNOWN_ITEM = Throwables.register("unknown_item", VALUE_EXCEPTION);
    public static final Throwables UNKNOWN_BLOCK = Throwables.register("unknown_block", VALUE_EXCEPTION);
    public static final Throwables UNKNOWN_BIOME = Throwables.register("unknown_biome", VALUE_EXCEPTION);
    public static final Throwables UNKNOWN_PARTICLE = Throwables.register("unknown_particle", VALUE_EXCEPTION);
    public static final Throwables UNKNOWN_POI = Throwables.register("unknown_poi", VALUE_EXCEPTION);
    public static final Throwables UNKNOWN_DIMENSION = Throwables.register("unknown_dimension", VALUE_EXCEPTION);
    public static final Throwables UNKNOWN_STRUCTURE = Throwables.register("unknown_structure", VALUE_EXCEPTION);
    public static final Throwables UNKNOWN_CRITERION = Throwables.register("unknown_criterion", VALUE_EXCEPTION);
    public static final Throwables UNKNOWN_SCREEN = Throwables.register("unknown_screen", VALUE_EXCEPTION);
    public static final Throwables IO_EXCEPTION = Throwables.register("io_exception", THROWN_EXCEPTION_TYPE);
    public static final Throwables NBT_ERROR = Throwables.register("nbt_error", IO_EXCEPTION);
    public static final Throwables JSON_ERROR = Throwables.register("json_error", IO_EXCEPTION);
    public static final Throwables B64_ERROR = Throwables.register("b64_error", IO_EXCEPTION);
    public static final Throwables USER_DEFINED = Throwables.register("user_exception", THROWN_EXCEPTION_TYPE);

    public static Throwables register(String id, @Nullable Throwables parent) {
        Throwables exc = new Throwables(id, parent);
        byId.put(id, exc);
        return exc;
    }

    public Throwables(String id, @Nullable Throwables parent) {
        this.id = id;
        this.parent = parent;
    }

    public static Throwables getTypeForException(String type) {
        Throwables properType = byId.get(type);
        if (properType == null) {
            throw new InternalExpressionException("Unknown exception type: " + type);
        }
        return properType;
    }

    public boolean isRelevantFor(String filter) {
        return this.id.equals(filter) || this.parent != null && this.parent.isRelevantFor(filter);
    }

    public boolean isUserException() {
        return this == USER_DEFINED || this.parent == USER_DEFINED;
    }

    public String getId() {
        return this.id;
    }
}

