/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.language;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.Token;
import carpet.script.argument.FunctionArgument;
import carpet.script.exception.ExitStatement;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.BooleanValue;
import carpet.script.value.NumericValue;
import carpet.script.value.ThreadValue;
import carpet.script.value.Value;

public class Threading {
    public static void apply(Expression expression) {
        expression.addFunctionWithDelegation("task", -1, false, false, (c, t, expr, tok, lv) -> {
            if (lv.isEmpty()) {
                throw new InternalExpressionException("'task' requires at least function to call as a parameter");
            }
            FunctionArgument functionArgument = FunctionArgument.findIn(c, expression.module, lv, 0, false, true);
            ThreadValue thread = new ThreadValue(Value.NULL, functionArgument.function, (Expression)expr, (Token)tok, (Context)c, functionArgument.checkedArgs());
            Thread.yield();
            return thread;
        });
        expression.addFunctionWithDelegation("task_thread", -1, false, false, (c, t, expr, tok, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'task' requires at least function to call as a parameter");
            }
            Value queue = (Value)lv.get(0);
            FunctionArgument functionArgument = FunctionArgument.findIn(c, expression.module, lv, 1, false, true);
            ThreadValue thread = new ThreadValue(queue, functionArgument.function, (Expression)expr, (Token)tok, (Context)c, functionArgument.checkedArgs());
            Thread.yield();
            return thread;
        });
        expression.addContextFunction("task_count", -1, (c, t, lv) -> !lv.isEmpty() ? new NumericValue(c.host.taskCount((Value)lv.get(0))) : new NumericValue(c.host.taskCount()));
        expression.addUnaryFunction("task_value", v -> {
            if (!(v instanceof ThreadValue)) {
                throw new InternalExpressionException("'task_value' could only be used with a task value");
            }
            ThreadValue tv = (ThreadValue)v;
            return tv.getValue();
        });
        expression.addUnaryFunction("task_join", v -> {
            if (!(v instanceof ThreadValue)) {
                throw new InternalExpressionException("'task_join' could only be used with a task value");
            }
            ThreadValue tv = (ThreadValue)v;
            return tv.join();
        });
        expression.addLazyFunction("task_dock", 1, (c, t, lv) -> (LazyValue)lv.get(0));
        expression.addUnaryFunction("task_completed", v -> {
            if (!(v instanceof ThreadValue)) {
                throw new InternalExpressionException("'task_completed' could only be used with a task value");
            }
            ThreadValue tv = (ThreadValue)v;
            return BooleanValue.of(tv.isFinished());
        });
        expression.addLazyFunction("synchronize", (c, t, lv) -> {
            if (lv.isEmpty()) {
                throw new InternalExpressionException("'synchronize' require at least an expression to synchronize");
            }
            Value lockValue = Value.NULL;
            int ind = 0;
            if (lv.size() == 2) {
                lockValue = ((LazyValue)lv.get(0)).evalValue((Context)c);
                ind = 1;
            }
            Object object = c.host.getLock(lockValue);
            synchronized (object) {
                Value ret = ((LazyValue)lv.get(ind)).evalValue((Context)c, (Context.Type)((Object)t));
                return (ct, tt) -> ret;
            }
        });
        expression.addLazyFunction("sleep", (c, t, lv) -> {
            long time = lv.isEmpty() ? 0L : NumericValue.asNumber(((LazyValue)lv.get(0)).evalValue((Context)c)).getLong();
            boolean interrupted = false;
            try {
                if (Thread.interrupted()) {
                    interrupted = true;
                }
                if (time > 0L) {
                    Thread.sleep(time);
                }
                Thread.yield();
            }
            catch (InterruptedException ignored) {
                interrupted = true;
            }
            if (interrupted) {
                Value exceptionally = Value.NULL;
                if (lv.size() > 1) {
                    exceptionally = ((LazyValue)lv.get(1)).evalValue((Context)c);
                }
                throw new ExitStatement(exceptionally);
            }
            return (cc, tt) -> new NumericValue(time);
        });
        expression.addLazyFunction("yield", (c, t, lv) -> {
            if (c.getThreadContext() == null) {
                throw new InternalExpressionException("'yield' can only be used in a task");
            }
            if (lv.isEmpty()) {
                throw new InternalExpressionException("'yield' requires at least one argument");
            }
            boolean lock = lv.size() > 1 && ((LazyValue)lv.get(1)).evalValue((Context)c, Context.BOOLEAN).getBoolean();
            Value value = ((LazyValue)lv.get(0)).evalValue((Context)c);
            Value ret = c.getThreadContext().ping(value, lock);
            return (cc, tt) -> ret;
        });
        expression.addLazyFunction("task_send", 2, (c, t, lv) -> {
            Value threadValue = ((LazyValue)lv.get(0)).evalValue((Context)c);
            if (!(threadValue instanceof ThreadValue)) {
                throw new InternalExpressionException("'task_next' requires a task value");
            }
            ThreadValue thread = (ThreadValue)threadValue;
            if (!thread.isCoroutine) {
                throw new InternalExpressionException("'task_next' requires a coroutine task value");
            }
            Value ret = ((LazyValue)lv.get(1)).evalValue((Context)c);
            thread.send(ret);
            return (cc, tt) -> Value.NULL;
        });
        expression.addLazyFunction("task_await", 1, (c, t, lv) -> {
            Value threadValue = ((LazyValue)lv.get(0)).evalValue((Context)c);
            if (!(threadValue instanceof ThreadValue)) {
                throw new InternalExpressionException("'task_await' requires a task value");
            }
            ThreadValue thread = (ThreadValue)threadValue;
            if (!thread.isCoroutine) {
                throw new InternalExpressionException("'task_await' requires a coroutine task value");
            }
            Value ret = thread.next();
            return ret == Value.EOL ? (cc, tt) -> Value.NULL : (cc, tt) -> ret;
        });
        expression.addLazyFunction("task_ready", 1, (c, t, lv) -> {
            Value threadValue = ((LazyValue)lv.get(0)).evalValue((Context)c);
            if (!(threadValue instanceof ThreadValue)) {
                throw new InternalExpressionException("'task_ready' requires a task value");
            }
            ThreadValue thread = (ThreadValue)threadValue;
            boolean ret = thread.isCoroutine && thread.hasNext();
            return (cc, tt) -> BooleanValue.of(ret);
        });
    }
}

