/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.CarpetContext;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.external.Vanilla;
import carpet.script.utils.EquipmentInventory;
import carpet.script.value.BlockValue;
import carpet.script.value.ContainerValueInterface;
import carpet.script.value.EntityValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.ScreenValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2203;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2290;
import net.minecraft.class_2291;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2491;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2509;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3954;
import net.minecraft.class_5455;
import net.minecraft.class_6067;
import net.minecraft.class_7225;
import org.jspecify.annotations.Nullable;

public class NBTSerializableValue
extends Value
implements ContainerValueInterface {
    private String nbtString = null;
    private class_2520 nbtTag = null;
    private Supplier<class_2520> nbtSupplier = null;
    private boolean owned = false;
    private static class_2522<class_2520> tagParser = class_2522.method_68662((DynamicOps)class_2509.field_11560);
    private static final Map<String, class_2290> itemCache = new HashMap<String, class_2290>();
    private static final Map<String, class_2203.class_2209> pathCache = new HashMap<String, class_2203.class_2209>();

    private NBTSerializableValue() {
    }

    public NBTSerializableValue(String nbtString) {
        this.nbtSupplier = () -> {
            try {
                return (class_2520)tagParser.method_67319(new StringReader(nbtString));
            }
            catch (CommandSyntaxException e) {
                throw new InternalExpressionException("Incorrect NBT data: " + nbtString);
            }
        };
        this.owned = true;
    }

    public NBTSerializableValue(class_2520 tag) {
        this.nbtTag = tag;
        this.owned = true;
    }

    public static Value of(class_2520 tag) {
        if (tag == null) {
            return Value.NULL;
        }
        return new NBTSerializableValue(tag);
    }

    public NBTSerializableValue(Supplier<class_2520> tagSupplier) {
        this.nbtSupplier = tagSupplier;
    }

    public static Value fromStack(class_1799 stack, class_5455 regs) {
        NBTSerializableValue value = new NBTSerializableValue();
        value.nbtSupplier = () -> (class_2520)class_1799.field_24671.encodeStart((DynamicOps)regs.method_57093((DynamicOps)class_2509.field_11560), (Object)stack).getOrThrow(s -> new InternalExpressionException("Failed to parse item stack data: " + s));
        return value;
    }

    public static Value nameFromRegistryId(@Nullable class_2960 id) {
        return StringValue.of(NBTSerializableValue.nameFromResource(id));
    }

    public static @Nullable String nameFromResource(@Nullable class_2960 id) {
        return id == null ? null : (id.method_12836().equals("minecraft") ? id.method_12832() : id.toString());
    }

    public static @Nullable NBTSerializableValue parseString(String nbtString) {
        try {
            class_2520 tag = (class_2520)tagParser.method_67319(new StringReader(nbtString));
            NBTSerializableValue value = new NBTSerializableValue(tag);
            value.nbtString = null;
            return value;
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    public static NBTSerializableValue parseStringOrFail(String nbtString) {
        NBTSerializableValue result = NBTSerializableValue.parseString(nbtString);
        if (result == null) {
            throw new InternalExpressionException("Incorrect NBT tag: " + nbtString);
        }
        return result;
    }

    public Value clone() {
        NBTSerializableValue copy = new NBTSerializableValue(this.nbtTag);
        copy.nbtSupplier = this.nbtSupplier;
        copy.nbtString = this.nbtString;
        copy.owned = this.owned;
        return copy;
    }

    @Override
    public Value deepcopy() {
        NBTSerializableValue copy = (NBTSerializableValue)this.clone();
        copy.owned = false;
        this.ensureOwnership();
        return copy;
    }

    @Override
    public Value fromConstant() {
        return this.deepcopy();
    }

    public static class_1263 getInventoryAt(class_3218 world, class_2338 blockPos) {
        List list;
        class_1263 inventoryHolder;
        class_2586 blockEntity;
        class_1278 inventory = null;
        class_2680 blockState = world.method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        if (block instanceof class_3954) {
            class_3954 containerHolder = (class_3954)block;
            inventory = containerHolder.method_17680(blockState, (class_1936)world, blockPos);
        } else if (blockState.method_31709() && (blockEntity = BlockValue.getBlockEntity((class_1937)world, blockPos)) instanceof class_1263 && (inventory = (inventoryHolder = (class_1263)blockEntity)) instanceof class_2595 && block instanceof class_2281) {
            class_2281 chestBlock = (class_2281)block;
            inventory = class_2281.method_17458((class_2281)chestBlock, (class_2680)blockState, (class_1937)world, (class_2338)blockPos, (boolean)true);
        }
        if (inventory == null && !(list = world.method_8333((class_1297)null, new class_238((double)blockPos.method_10263() - 0.5, (double)blockPos.method_10264() - 0.5, (double)blockPos.method_10260() - 0.5, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5), class_1301.field_6152)).isEmpty()) {
            inventory = (class_1263)list.get(world.field_9229.method_43048(list.size()));
        }
        return inventory;
    }

    public static InventoryLocator locateInventory(CarpetContext c, List<Value> params, int offset) {
        try {
            Value v1 = params.get(offset);
            if (v1.isNull()) {
                v1 = params.get(++offset);
            } else if (v1 instanceof StringValue) {
                class_3222 player;
                String strVal = v1.getString().toLowerCase(Locale.ROOT);
                if (strVal.equals("enderchest")) {
                    Value v2 = params.get(1 + offset);
                    class_3222 player2 = EntityValue.getPlayerByValue(c.server(), v2);
                    if (player2 == null) {
                        throw new InternalExpressionException("enderchest inventory requires player argument");
                    }
                    return new InventoryLocator(player2, player2.method_24515(), (class_1263)player2.method_7274(), offset + 2, true);
                }
                if (strVal.equals("equipment")) {
                    Value v2 = params.get(1 + offset);
                    if (!(v2 instanceof EntityValue)) {
                        throw new InternalExpressionException("Equipment inventory requires a living entity argument");
                    }
                    EntityValue ev = (EntityValue)v2;
                    class_1297 e = ev.getEntity();
                    if (!(e instanceof class_1309)) {
                        throw new InternalExpressionException("Equipment inventory requires a living entity argument");
                    }
                    class_1309 le = (class_1309)e;
                    return new InventoryLocator(e, e.method_24515(), new EquipmentInventory(le), offset + 2);
                }
                boolean isEnder = strVal.startsWith("enderchest_");
                if (isEnder) {
                    strVal = strVal.substring(11);
                }
                if ((player = c.server().method_3760().method_14566(strVal)) == null) {
                    throw new InternalExpressionException("String description of an inventory should either denote a player or player's enderchest");
                }
                return new InventoryLocator(player, player.method_24515(), (class_1263)(isEnder ? player.method_7274() : player.method_31548()), offset + 1, isEnder);
            }
            if (v1 instanceof EntityValue) {
                EntityValue ev = (EntityValue)v1;
                class_1661 inv = null;
                class_1297 e = ev.getEntity();
                if (e instanceof class_1657) {
                    class_1657 pe = (class_1657)e;
                    inv = pe.method_31548();
                } else if (e instanceof class_1263) {
                    class_1263 container = (class_1263)e;
                    inv = container;
                } else if (e instanceof class_6067) {
                    class_6067 io = (class_6067)e;
                    inv = io.method_35199();
                } else if (e instanceof class_1496) {
                    class_1496 ibi = (class_1496)e;
                    inv = Vanilla.AbstractHorse_getInventory(ibi);
                } else if (e instanceof class_1309) {
                    class_1309 le = (class_1309)e;
                    return new InventoryLocator(e, e.method_24515(), new EquipmentInventory(le), offset + 1);
                }
                return inv == null ? null : new InventoryLocator(e, e.method_24515(), (class_1263)inv, offset + 1);
            }
            if (v1 instanceof BlockValue) {
                BlockValue bv = (BlockValue)v1;
                class_2338 pos = bv.getPos();
                if (pos == null) {
                    throw new InternalExpressionException("Block to access inventory needs to be positioned in the world");
                }
                class_1263 inv = NBTSerializableValue.getInventoryAt(c.level(), pos);
                return inv == null ? null : new InventoryLocator(pos, pos, inv, offset + 1);
            }
            if (v1 instanceof ListValue) {
                ListValue lv = (ListValue)v1;
                List<Value> args = lv.getItems();
                class_2338 pos = class_2338.method_49637((double)NumericValue.asNumber(args.get(0)).getDouble(), (double)NumericValue.asNumber(args.get(1)).getDouble(), (double)NumericValue.asNumber(args.get(2)).getDouble());
                class_1263 inv = NBTSerializableValue.getInventoryAt(c.level(), pos);
                return inv == null ? null : new InventoryLocator(pos, pos, inv, offset + 1);
            }
            if (v1 instanceof ScreenValue) {
                ScreenValue screenValue = (ScreenValue)v1;
                return !screenValue.isOpen() ? null : new InventoryLocator(screenValue.getPlayer(), screenValue.getPlayer().method_24515(), screenValue.getInventory(), offset + 1);
            }
            class_2338 pos = class_2338.method_49637((double)NumericValue.asNumber(v1).getDouble(), (double)NumericValue.asNumber(params.get(1 + offset)).getDouble(), (double)NumericValue.asNumber(params.get(2 + offset)).getDouble());
            class_1263 inv = NBTSerializableValue.getInventoryAt(c.level(), pos);
            return inv == null ? null : new InventoryLocator(pos, pos, inv, offset + 3);
        }
        catch (IndexOutOfBoundsException e) {
            throw new InternalExpressionException("Inventory should be defined either by three coordinates, a block value, an entity, or a screen");
        }
    }

    public static class_1799 parseItem(String itemString, class_5455 regs) {
        return NBTSerializableValue.parseItem(itemString, null, regs);
    }

    public static class_1799 parseItem(String itemString, @Nullable class_2487 customTag, class_5455 regs) {
        if (customTag != null) {
            return (class_1799)class_1799.field_24671.parse((DynamicOps)regs.method_57093((DynamicOps)class_2509.field_11560), (Object)customTag).getOrThrow(s -> new InternalExpressionException("Failed to parse item stack data: " + s));
        }
        try {
            class_2290 res = itemCache.get(itemString);
            if (res != null) {
                return res.method_9781(1, false);
            }
            class_2291.class_7215 parser = new class_2291((class_7225.class_7874)regs).method_9789(new StringReader(itemString));
            res = new class_2290(parser.comp_628(), parser.comp_2439());
            itemCache.put(itemString, res);
            if (itemCache.size() > 64000) {
                itemCache.clear();
            }
            return res.method_9781(1, false);
        }
        catch (CommandSyntaxException e) {
            throw new ThrowStatement(itemString, Throwables.UNKNOWN_ITEM);
        }
    }

    public static int validateSlot(int slot, class_1263 inv) {
        int invSize = inv.method_5439();
        if (slot < 0) {
            slot = invSize + slot;
        }
        return slot < 0 || slot >= invSize ? inv.method_5439() : slot;
    }

    private static Value decodeSimpleTag(class_2520 t) {
        if (t instanceof class_2514) {
            class_2514 number = (class_2514)t;
            return t instanceof class_2503 || t instanceof class_2497 ? NumericValue.of(number.method_10699()) : NumericValue.of((Number)number.method_68599().orElseThrow());
        }
        if (t instanceof class_2519) {
            class_2519 stringTag = (class_2519)t;
            return StringValue.of(stringTag.comp_3831());
        }
        if (t instanceof class_2491) {
            return Value.NULL;
        }
        throw new InternalExpressionException("How did we get here: Unknown nbt element class: " + t.method_23258().method_23259());
    }

    private static Value decodeTag(class_2520 t) {
        return t instanceof class_2487 || t instanceof class_2483 ? new NBTSerializableValue(() -> t) : NBTSerializableValue.decodeSimpleTag(t);
    }

    private static Value decodeTagDeep(class_2520 t) {
        if (t instanceof class_2487) {
            class_2487 ctag = (class_2487)t;
            HashMap<Value, Value> pairs = new HashMap<Value, Value>();
            for (String key : ctag.method_10541()) {
                pairs.put(new StringValue(key), NBTSerializableValue.decodeTagDeep(ctag.method_10580(key)));
            }
            return MapValue.wrap(pairs);
        }
        if (t instanceof class_2483) {
            class_2483 ltag = (class_2483)t;
            ArrayList<Value> elems = new ArrayList<Value>();
            for (class_2520 elem : ltag) {
                elems.add(NBTSerializableValue.decodeTagDeep(elem));
            }
            return ListValue.wrap(elems);
        }
        return NBTSerializableValue.decodeSimpleTag(t);
    }

    public Value toValue() {
        return NBTSerializableValue.decodeTagDeep(this.getTag());
    }

    public static Value fromValue(Value v) {
        if (v instanceof NBTSerializableValue) {
            return v;
        }
        if (v.isNull()) {
            return Value.NULL;
        }
        return NBTSerializableValue.parseStringOrFail(v.getString());
    }

    public class_2520 getTag() {
        if (this.nbtTag == null) {
            this.nbtTag = this.nbtSupplier.get();
        }
        return this.nbtTag;
    }

    @Override
    public boolean equals(Object o) {
        boolean bl;
        if (o instanceof NBTSerializableValue) {
            NBTSerializableValue nbtsv = (NBTSerializableValue)o;
            bl = this.getTag().equals((Object)nbtsv.getTag());
        } else {
            bl = super.equals(o);
        }
        return bl;
    }

    @Override
    public String getString() {
        if (this.nbtString == null) {
            this.nbtString = this.getTag().toString();
        }
        return this.nbtString;
    }

    @Override
    public boolean getBoolean() {
        class_2520 tag = this.getTag();
        if (tag instanceof class_2487) {
            class_2487 ctag = (class_2487)tag;
            return !ctag.method_33133();
        }
        if (tag instanceof class_2483) {
            class_2483 ltag = (class_2483)tag;
            return !ltag.isEmpty();
        }
        if (tag instanceof class_2514) {
            class_2514 number = (class_2514)tag;
            return number.method_10697() != 0.0;
        }
        if (tag instanceof class_2519) {
            class_2519 st = (class_2519)tag;
            return !st.comp_3831().isEmpty();
        }
        return true;
    }

    public class_2487 getCompoundTag() {
        try {
            this.ensureOwnership();
            return (class_2487)this.getTag();
        }
        catch (ClassCastException e) {
            throw new InternalExpressionException(this.getString() + " is not a valid compound tag");
        }
    }

    @Override
    public boolean put(Value where, Value value) {
        return this.put(where, value, new StringValue("replace"));
    }

    @Override
    public boolean put(Value where, Value value, Value conditions) {
        boolean modifiedTag;
        class_2520 tagToInsert;
        this.ensureOwnership();
        class_2203.class_2209 path = NBTSerializableValue.cachePath(where.getString());
        if (value instanceof NBTSerializableValue) {
            NBTSerializableValue nbtsv = (NBTSerializableValue)value;
            v0 = nbtsv.getTag();
        } else {
            v0 = tagToInsert = new NBTSerializableValue(value.getString()).getTag();
        }
        if (conditions instanceof NumericValue) {
            NumericValue number = (NumericValue)conditions;
            modifiedTag = this.modifyInsert((int)number.getLong(), path, tagToInsert);
        } else {
            String ops = conditions.getString();
            if (ops.equalsIgnoreCase("merge")) {
                modifiedTag = this.modifyMerge(path, tagToInsert);
            } else if (ops.equalsIgnoreCase("replace")) {
                modifiedTag = this.modifyReplace(path, tagToInsert);
            } else {
                return false;
            }
        }
        if (modifiedTag) {
            this.dirty();
        }
        return modifiedTag;
    }

    private boolean modifyInsert(int index, class_2203.class_2209 nbtPath, class_2520 newElement) {
        return this.modifyInsert(index, nbtPath, newElement, this.getTag());
    }

    private boolean modifyInsert(int index, class_2203.class_2209 nbtPath, class_2520 newElement, class_2520 currentTag) {
        List targets;
        try {
            targets = nbtPath.method_9367(currentTag, class_2499::new);
        }
        catch (CommandSyntaxException e) {
            return false;
        }
        boolean modified = false;
        for (class_2520 target : targets) {
            if (!(target instanceof class_2483)) continue;
            class_2483 targetList = (class_2483)target;
            try {
                if (!targetList.method_10533(index < 0 ? targetList.size() + index + 1 : index, newElement.method_10707())) {
                    return false;
                }
                modified = true;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        return modified;
    }

    private boolean modifyMerge(class_2203.class_2209 nbtPath, class_2520 replacement) {
        if (!(replacement instanceof class_2487)) {
            return false;
        }
        class_2487 replacementCompound = (class_2487)replacement;
        class_2520 ownTag = this.getTag();
        try {
            for (class_2520 target : nbtPath.method_9367(ownTag, class_2487::new)) {
                if (!(target instanceof class_2487)) continue;
                class_2487 targetCompound = (class_2487)target;
                targetCompound.method_10543(replacementCompound);
            }
        }
        catch (CommandSyntaxException ignored) {
            return false;
        }
        return true;
    }

    private boolean modifyReplace(class_2203.class_2209 nbtPath, class_2520 replacement) {
        class_2520 tag = this.getTag();
        String pathText = nbtPath.toString();
        if (pathText.endsWith("]")) {
            int pos;
            if (nbtPath.method_9372(tag) == 0) {
                return false;
            }
            Pattern pattern = Pattern.compile("\\[[^\\[]*]$");
            Matcher matcher = pattern.matcher(pathText);
            if (!matcher.find()) {
                return false;
            }
            String arrAccess = matcher.group();
            if (arrAccess.length() == 2) {
                pos = 0;
            } else {
                try {
                    pos = Integer.parseInt(arrAccess.substring(1, arrAccess.length() - 1));
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            class_2203.class_2209 newPath = NBTSerializableValue.cachePath(pathText.substring(0, pathText.length() - arrAccess.length()));
            return this.modifyInsert(pos, newPath, replacement, tag);
        }
        try {
            nbtPath.method_35722(tag, replacement);
        }
        catch (CommandSyntaxException e) {
            return false;
        }
        return true;
    }

    @Override
    public Value get(Value value) {
        String valString = value.getString();
        class_2203.class_2209 path = NBTSerializableValue.cachePath(valString);
        try {
            List tags = path.method_9366(this.getTag());
            if (tags.isEmpty()) {
                return Value.NULL;
            }
            if (tags.size() == 1 && !valString.endsWith("[]")) {
                return NBTSerializableValue.decodeTag((class_2520)tags.get(0));
            }
            return ListValue.wrap(tags.stream().map(NBTSerializableValue::decodeTag));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return Value.NULL;
        }
    }

    @Override
    public boolean has(Value where) {
        return NBTSerializableValue.cachePath(where.getString()).method_9374(this.getTag()) > 0;
    }

    private void ensureOwnership() {
        if (!this.owned) {
            this.nbtTag = this.getTag().method_10707();
            this.nbtString = null;
            this.nbtSupplier = null;
            this.owned = true;
        }
    }

    private void dirty() {
        this.nbtString = null;
    }

    @Override
    public boolean delete(Value where) {
        class_2203.class_2209 path = NBTSerializableValue.cachePath(where.getString());
        this.ensureOwnership();
        int removed = path.method_9372(this.getTag());
        if (removed > 0) {
            this.dirty();
            return true;
        }
        return false;
    }

    private static class_2203.class_2209 cachePath(String arg) {
        class_2203.class_2209 res = pathCache.get(arg);
        if (res != null) {
            return res;
        }
        try {
            res = class_2203.method_9360().method_9362(new StringReader(arg));
        }
        catch (CommandSyntaxException exc) {
            throw new InternalExpressionException("Incorrect nbt path: " + arg);
        }
        if (pathCache.size() > 1024) {
            pathCache.clear();
        }
        pathCache.put(arg, res);
        return res;
    }

    @Override
    public String getTypeString() {
        return "nbt";
    }

    @Override
    public class_2520 toTag(boolean force, class_5455 regs) {
        if (!force) {
            throw new IncompatibleTypeException(this);
        }
        this.ensureOwnership();
        return this.getTag();
    }

    public record InventoryLocator(Object owner, class_2338 position, class_1263 inventory, int offset, boolean isEnder) {
        InventoryLocator(Object owner, class_2338 pos, class_1263 i, int o) {
            this(owner, pos, i, o, false);
        }
    }

    public static class IncompatibleTypeException
    extends RuntimeException {
        public final Value val;

        public IncompatibleTypeException(Value val) {
            this.val = val;
        }
    }
}

