/*
 * Decompiled with CFR 0.152.
 */
package net.thedustbuster.cee.server;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.thedustbuster.cee.server.CarpetExtraExtrasSettings;
import net.thedustbuster.cee.server.commands.CEE_Command;
import net.thedustbuster.cee.server.rules.CEE_Rule;
import net.thedustbuster.cee.server.util.Logger;
import net.thedustbuster.cee.server.util.TickDelayManager;
import net.thedustbuster.libs.core.classloading.ClassLoader;
import net.thedustbuster.libs.func.Unit;
import net.thedustbuster.libs.func.option.Option;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;

public final class CarpetExtraExtrasServer
implements CarpetExtension,
ModInitializer {
    public static final String MOD_ID = "carpet-extra-extras";
    public static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger((String)"carpet-extra-extras");
    private static final List<CEE_Rule> rules = new ArrayList<CEE_Rule>();
    private static final List<CEE_Command> commands = new ArrayList<CEE_Command>();

    public static void registerRule(CEE_Rule r) {
        rules.add(r);
    }

    public static void registerCommand(CEE_Command c) {
        commands.add(c);
    }

    private static Option<MinecraftServer> getMinecraftServerUnsafe() {
        return Option.of((Object)CarpetServer.minecraft_server);
    }

    public static Option<MinecraftServer> getMinecraftServer() {
        return CarpetExtraExtrasServer.getMinecraftServerUnsafe().filter(MinecraftServer::method_3820);
    }

    public static void runOnServerThread(Consumer<MinecraftServer> r) {
        CarpetExtraExtrasServer.getMinecraftServer().fold(s -> Unit.Unit(() -> s.execute(() -> r.accept((MinecraftServer)s))), () -> Logger.warn("Attempted to run on a non-ready server thread."));
    }

    public static void runOnServerThreadUnsafe(Consumer<MinecraftServer> r) {
        CarpetExtraExtrasServer.getMinecraftServerUnsafe().fold(s -> Unit.Unit(() -> s.execute(() -> r.accept((MinecraftServer)s))), () -> Logger.warn("Attempted to run on a non-existent server thread."));
    }

    public static void reloadCommands() {
        CarpetExtraExtrasServer.runOnServerThreadUnsafe(server -> {
            commands.forEach(c -> c.register((CommandDispatcher<class_2168>)server.method_3734().method_9235()));
            server.method_3760().method_14571().forEach(p -> server.method_3734().method_9241(p));
        });
    }

    public void onInitialize() {
        CarpetServer.manageExtension((CarpetExtension)this);
        new ClassLoader("net.thedustbuster.cee.server.rules").load();
        new ClassLoader("net.thedustbuster.cee.server.commands").load();
    }

    public void onServerLoaded(MinecraftServer server) {
        CarpetExtraExtrasServer.reloadCommands();
    }

    public void onTick(MinecraftServer server) {
        rules.forEach(CEE_Rule::onTick);
        TickDelayManager.tick();
    }

    public void onPlayerLoggedIn(class_3222 player) {
        rules.forEach(rule -> rule.onPlayerLoggedIn(player));
    }

    public void onPlayerLoggedOut(class_3222 player) {
        rules.forEach(rule -> rule.onPlayerLoggedOut(player));
    }

    public void onGameStarted() {
        CarpetServer.settingsManager.parseSettingsClass(CarpetExtraExtrasSettings.class);
        rules.forEach(CEE_Rule::onGameStarted);
    }

    public Map<String, String> canHasTranslations(String lang) {
        String jsonData;
        InputStream langFile = CarpetExtraExtrasServer.class.getClassLoader().getResourceAsStream("assets/carpet-extra-extras/lang/%s.json".formatted(lang));
        if (langFile == null) {
            return Collections.emptyMap();
        }
        try {
            jsonData = IOUtils.toString((InputStream)langFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
        Gson gson = new GsonBuilder().create();
        return (Map)gson.fromJson(jsonData, new TypeToken<Map<String, String>>(){}.getType());
    }
}

