/*
 * Decompiled with CFR 0.152.
 */
package net.thedustbuster.cee.server;

import carpet.api.settings.CarpetRule;
import carpet.api.settings.Rule;
import carpet.api.settings.Validator;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.thedustbuster.cee.server.CarpetExtraExtrasServer;
import net.thedustbuster.cee.server.rules.CarpetBotTeam;
import net.thedustbuster.cee.server.rules.PearlTracking;
import org.jetbrains.annotations.Nullable;

public class CarpetExtraExtrasSettings {
    public static final String MOD = "CarpetExtraExtras";
    public static final String FEATURE = "Feature";
    public static final String BUGFIX = "Bugfix";
    public static final String LTS = "LTS";
    public static final String COMMAND = "Command";
    public static final String VANILLA = "Vanilla";
    public static final String OPTIMIZATION = "Optimization";
    public static final String EXPERIMENTAL = "Experimental";
    public static final int MAX_TEAM_NAME_LENGTH = 64;
    public static final int MAX_TEAM_PREFIX_LENGTH = 16;
    @Rule(categories={"Vanilla", "CarpetExtraExtras"}, validators={trackEnderPearlsValidator.class})
    public static boolean trackEnderPearls = false;
    @Rule(categories={"Feature", "LTS", "CarpetExtraExtras"})
    public static boolean pre21ThrowableEntityBehavior = false;
    @Rule(categories={"Feature", "Experimental", "Optimization", "CarpetExtraExtras"})
    public static boolean optimizedTNTInteraction = false;
    @Rule(categories={"Feature", "LTS", "CarpetExtraExtras"}, options={"false", "1", "16", "64"}, strict=false, validators={StackableShulkerValidator.class})
    public static String stackableShulkerLimitAllContainers = "false";
    private static int stackableShulkerLimitAllContainersParsed = -1;
    @Rule(categories={"Feature", "LTS", "CarpetExtraExtras"}, options={"false", "1", "16", "64"}, strict=false, validators={StackableShulkerValidator.class})
    public static String stackableShulkerLimitHoppers = "false";
    private static int stackableShulkerLimitHoppersParsed = -1;
    @Rule(categories={"Feature", "LTS", "CarpetExtraExtras"}, options={"false", "1", "16", "64"}, strict=false, validators={StackableShulkerValidator.class})
    public static String stackableShulkerLimitDroppers = "false";
    private static int stackableShulkerLimitDroppersParsed = -1;
    @Rule(categories={"Feature", "LTS", "CarpetExtraExtras"}, options={"false", "1", "16", "64"}, strict=false, validators={StackableShulkerValidator.class})
    public static String stackableShulkerLimitDispensers = "false";
    private static int stackableShulkerLimitDispensersParsed = -1;
    @Rule(categories={"Feature", "CarpetExtraExtras"})
    public static boolean carpetBotsSkipNight = false;
    @Rule(categories={"Feature", "CarpetExtraExtras"}, validators={CarpetBotTeamValidator.class})
    public static boolean carpetBotTeam = false;
    @Rule(categories={"Feature", "CarpetExtraExtras"}, validators={CarpetBotTeamNameValidator.class})
    public static String carpetBotTeamName = "cee_bots";
    @Rule(categories={"Feature", "CarpetExtraExtras"}, validators={CarpetBotTeamPrefixValidator.class})
    public static String carpetBotTeamPrefix = "[Bot]";
    @Rule(categories={"Feature", "CarpetExtraExtras"}, validators={CarpetBotTeamColorValidator.class})
    public static class_124 carpetBotTeamColor = class_124.field_1080;
    @Rule(categories={"Feature", "CarpetExtraExtras"}, validators={CarpetBotTeamColorValidator.class})
    public static class_124 carpetBotTeamPrefixColor = class_124.field_1065;
    @Rule(categories={"Feature", "Command", "CarpetExtraExtras"}, options={"true", "false", "ops", "0", "1", "2", "3", "4"}, validators={CommandValidator.class})
    public static String commandCam = "false";
    @Rule(categories={"Feature", "Command", "CarpetExtraExtras"}, options={"true", "false", "ops", "0", "1", "2", "3", "4"}, validators={CommandValidator.class})
    public static String commandPing = "false";

    private static void updateTeam() {
        if (CarpetExtraExtrasServer.getMinecraftServer().isEmpty()) {
            return;
        }
        CarpetExtraExtrasServer.runOnServerThread(__ -> CarpetBotTeam.updateTeam());
    }

    public static int getStackableShulkerLimitAllContainers() {
        return stackableShulkerLimitAllContainersParsed;
    }

    public static int getStackableShulkerLimitHoppers() {
        return stackableShulkerLimitHoppersParsed;
    }

    public static int getStackableShulkerLimitDroppers() {
        return stackableShulkerLimitDroppersParsed;
    }

    public static int getStackableShulkerLimitDispensers() {
        return stackableShulkerLimitDispensersParsed;
    }

    private static class CommandValidator
    extends Validator<String> {
        private CommandValidator() {
        }

        public String validate(class_2168 source, CarpetRule<String> changingRule, String newValue, String userInput) {
            CarpetExtraExtrasServer.reloadCommands();
            return newValue;
        }
    }

    private static class CarpetBotTeamColorValidator
    extends Validator<class_124> {
        private CarpetBotTeamColorValidator() {
        }

        public class_124 validate(@Nullable class_2168 source, CarpetRule<class_124> changingRule, class_124 newValue, String userInput) {
            CarpetExtraExtrasSettings.updateTeam();
            return newValue;
        }
    }

    private static class CarpetBotTeamPrefixValidator
    extends Validator<String> {
        private CarpetBotTeamPrefixValidator() {
        }

        public String validate(@Nullable class_2168 source, CarpetRule<String> changingRule, String newValue, String userInput) {
            CarpetExtraExtrasSettings.updateTeam();
            return newValue.length() <= 16 ? newValue : null;
        }

        public String description() {
            return "You must choose a value from 0 to 16";
        }
    }

    private static class CarpetBotTeamNameValidator
    extends Validator<String> {
        private CarpetBotTeamNameValidator() {
        }

        public String validate(@Nullable class_2168 source, CarpetRule<String> changingRule, String newValue, String userInput) {
            CarpetExtraExtrasSettings.updateTeam();
            return newValue.length() <= 64 ? newValue : null;
        }

        public String description() {
            return "You must choose a value from 0 to 64";
        }
    }

    private static class CarpetBotTeamValidator
    extends Validator<Boolean> {
        private CarpetBotTeamValidator() {
        }

        public Boolean validate(class_2168 source, CarpetRule<Boolean> changingRule, Boolean newValue, String userInput) {
            CarpetExtraExtrasSettings.updateTeam();
            return newValue;
        }
    }

    private static class StackableShulkerValidator
    extends Validator<String> {
        private StackableShulkerValidator() {
        }

        public String validate(@Nullable class_2168 source, CarpetRule<String> changingRule, String newValue, String userInput) {
            int parsed = -1;
            if (!newValue.equals("false")) {
                try {
                    parsed = Integer.parseInt(newValue);
                    if (parsed < 1 || parsed > 64) {
                        return null;
                    }
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            switch (changingRule.name()) {
                case "stackableShulkerLimitAllContainers": {
                    stackableShulkerLimitAllContainersParsed = parsed;
                    break;
                }
                case "stackableShulkerLimitHoppers": {
                    stackableShulkerLimitHoppersParsed = parsed;
                    break;
                }
                case "stackableShulkerLimitDroppers": {
                    stackableShulkerLimitDroppersParsed = parsed;
                    break;
                }
                case "stackableShulkerLimitDispensers": {
                    stackableShulkerLimitDispensersParsed = parsed;
                }
            }
            return newValue;
        }

        public String description() {
            return "Valid options include: false, 1-64";
        }
    }

    private static class trackEnderPearlsValidator
    extends Validator<Boolean> {
        private trackEnderPearlsValidator() {
        }

        public Boolean validate(@Nullable class_2168 source, CarpetRule<Boolean> changingRule, Boolean newValue, String userInput) {
            if (!newValue.booleanValue()) {
                CarpetExtraExtrasServer.getMinecraftServer().whenDefined(server -> server.execute(PearlTracking::removedAllTrackedPearls));
            }
            return newValue;
        }
    }
}

