/*
 * Decompiled with CFR 0.152.
 */
package net.thedustbuster.cee.server.adaptors.minecraft.text;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.thedustbuster.libs.core.tuple.Pair;
import net.thedustbuster.libs.func.Attempt;
import net.thedustbuster.libs.func.option.Option;

public class TextBuffer {
    private final List<FormattedText> formattedTexts = new ArrayList<FormattedText>();

    private List<FormattedText> getAllText() {
        return this.formattedTexts;
    }

    public static Option<class_124> getFormattingFromString(String str) {
        return Attempt.create(() -> class_124.valueOf((String)str.toUpperCase())).toOption();
    }

    public static String getTranslation(String key) {
        return class_2561.method_43471((String)key).getString();
    }

    public static class_2561 blank() {
        return class_2561.method_43473();
    }

    public static class_2561 text(String str) {
        return new TextBuffer().addText(str).build();
    }

    public static class_2561 text(String str, class_124 formatting) {
        return new TextBuffer().addText(str, List.of(formatting)).build();
    }

    public static class_2561 text(String str, List<class_124> formatting) {
        return new TextBuffer().addText(str, formatting).build();
    }

    public TextBuffer merge(TextBuffer builder) {
        this.formattedTexts.addAll(builder.getAllText());
        return this;
    }

    public TextBuffer addAllText(List<Pair<String, List<class_124>>> lines) {
        lines.forEach(line -> this.addText((String)line._1(), (List)line._2()));
        return this;
    }

    public TextBuffer addText(String text, List<class_124> formatting) {
        this.formattedTexts.add(new FormattedText(text, formatting));
        return this;
    }

    public TextBuffer addText(String text, class_124 formatting) {
        this.formattedTexts.add(new FormattedText(text, List.of(formatting)));
        return this;
    }

    public TextBuffer addText(String text) {
        this.formattedTexts.add(new FormattedText(text, List.of(class_124.field_1068)));
        return this;
    }

    public class_2561 buildWithNoItalics() {
        return this.build().method_27661().method_27694(__ -> __.method_10978(Boolean.valueOf(false)));
    }

    public class_2561 build() {
        class_5250 finalComponentText = class_2561.method_43473();
        for (FormattedText formattedText : this.formattedTexts) {
            class_5250 textComponent = class_2561.method_43470((String)formattedText.text());
            List<class_124> formatting = formattedText.formatting();
            for (class_124 format : formatting) {
                textComponent = textComponent.method_27661().method_27692(format);
            }
            finalComponentText = finalComponentText.method_27661().method_10852((class_2561)textComponent);
        }
        return finalComponentText;
    }

    private record FormattedText(String text, List<class_124> formatting) {
        private FormattedText(String text, List<class_124> formatting) {
            this.text = text != null ? text : "";
            this.formatting = formatting != null ? formatting : List.of(class_124.field_1068);
        }
    }
}

