/*
 * Decompiled with CFR 0.152.
 */
package net.thedustbuster.cee.server.commands;

import carpet.utils.CommandHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2709;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.thedustbuster.cee.server.CarpetExtraExtrasServer;
import net.thedustbuster.cee.server.CarpetExtraExtrasSettings;
import net.thedustbuster.cee.server.adaptors.minecraft.MessagingHelper;
import net.thedustbuster.cee.server.adaptors.minecraft.text.TextBuffer;
import net.thedustbuster.cee.server.commands.CEE_Command;
import net.thedustbuster.cee.server.util.Logger;
import net.thedustbuster.libs.core.classloading.LoadAtRuntime;
import net.thedustbuster.libs.core.tuple.Pair;
import net.thedustbuster.libs.func.Attempt;
import net.thedustbuster.libs.func.Unit;
import net.thedustbuster.libs.func.option.Option;

@LoadAtRuntime
public final class CamCommand
implements CEE_Command {
    public static final CamCommand INSTANCE = new CamCommand();
    private static final Map<UUID, FreecamData> playerDataMap;

    private CamCommand() {
    }

    public static Option<FreecamData> getPlayerData(UUID id) {
        return Option.of((Object)playerDataMap.get(id));
    }

    public static void addPlayerData(UUID id, FreecamData data) {
        playerDataMap.put(id, data);
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralCommandNode camCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"cam").requires(player -> CommandHelper.canUseCommand((class_2168)player, (Object)CarpetExtraExtrasSettings.commandCam))).executes(c -> {
            this.executeCommand((class_2168)c.getSource());
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"c").requires(player -> CommandHelper.canUseCommand((class_2168)player, (Object)CarpetExtraExtrasSettings.commandCam))).executes(c -> dispatcher.execute(camCommand.getLiteral(), (Object)((class_2168)c.getSource()))));
    }

    private void executeCommand(class_2168 context) {
        Attempt.create(() -> {
            class_3222 player = context.method_9207();
            return new Pair((Object)player, (Object)Option.of((Object)playerDataMap.get(player.method_5667())));
        }).map(tuple -> (Unit)((Option)tuple._2()).fold(data -> this.exitFreecam((class_3222)tuple._1(), (FreecamData)data), () -> this.enterFreecam((class_3222)tuple._1()))).getOrHandle(this::handleExecutionError);
    }

    private Unit enterFreecam(class_3222 player) {
        FreecamData data = new FreecamData(player.field_13974.method_14257(), player.method_73189(), player.method_5802(), (class_5321<class_1937>)player.method_51469().method_27983());
        playerDataMap.put(player.method_5667(), data);
        player.method_7336(class_1934.field_9219);
        MessagingHelper.sendActionBarMessage(player, new TextBuffer().addText("Gamemode: ", class_124.field_1065).addText("SPECTATOR", class_124.field_1068).build());
        return Unit.Unit;
    }

    private Unit exitFreecam(class_3222 player, FreecamData data) {
        MinecraftServer server = (MinecraftServer)CarpetExtraExtrasServer.getMinecraftServer().getOrThrow(() -> new IllegalStateException("Minecraft Server is not ready"));
        player.method_7336(data.gamemode());
        player.method_48105(server.method_3847(data.level()), data.position().method_10216(), data.position().method_10214(), data.position().method_10215(), EnumSet.noneOf(class_2709.class), data.rotation().field_1342, data.rotation().field_1343, true);
        playerDataMap.remove(player.method_5667());
        MessagingHelper.sendActionBarMessage(player, new TextBuffer().addText("Gamemode: ", class_124.field_1065).addText(data.gamemode.method_8381().toUpperCase(), class_124.field_1068).build());
        return Unit.Unit;
    }

    private Unit handleExecutionError(Throwable e) {
        if (e instanceof CommandSyntaxException) {
            Logger.warn("CommandSyntaxException: " + e.getMessage());
        } else {
            Logger.error("Unexpected error during command execution" + String.valueOf(e));
        }
        return Unit.Unit;
    }

    static {
        CarpetExtraExtrasServer.registerCommand(INSTANCE);
        playerDataMap = new HashMap<UUID, FreecamData>();
    }

    public record FreecamData(class_1934 gamemode, class_243 position, class_241 rotation, class_5321<class_1937> level) {
        public static final Codec<FreecamData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1934.field_41676.fieldOf("gamemode").forGetter(FreecamData::gamemode), (App)class_243.field_38277.fieldOf("position").forGetter(FreecamData::position), (App)class_241.field_56695.fieldOf("rotation").forGetter(FreecamData::rotation), (App)class_5321.method_39154((class_5321)class_7924.field_41223).fieldOf("level").forGetter(FreecamData::level)).apply((Applicative)instance, FreecamData::new));
    }
}

