/*
 * Decompiled with CFR 0.152.
 */
package net.thedustbuster.cee.server.rules;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1684;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.thedustbuster.cee.server.adaptors.minecraft.text.TextBuffer;
import net.thedustbuster.cee.server.rules.CEE_Rule;

public class PearlTracking
implements CEE_Rule {
    private static final Map<UUID, EnderPearlData> trackedEnderPearls = new HashMap<UUID, EnderPearlData>();

    public static Map<UUID, EnderPearlData> getTrackedEnderPearls() {
        return Collections.unmodifiableMap(trackedEnderPearls);
    }

    public static void removedAllTrackedPearls() {
        trackedEnderPearls.clear();
    }

    public static void removePearl(UUID id) {
        trackedEnderPearls.remove(id);
    }

    public static void updatePearl(class_1684 entity, class_243 position, class_243 velocity) {
        trackedEnderPearls.computeIfAbsent(entity.method_5667(), id -> new EnderPearlData(entity, position, velocity)).updatePositionAndVelocity(position, velocity);
    }

    public static class_2561[] createHUD() {
        return (class_2561[])PearlTracking.getTrackedEnderPearls().entrySet().stream().map(entry -> {
            UUID key = (UUID)entry.getKey();
            EnderPearlData pearl = (EnderPearlData)entry.getValue();
            String uuid = key != null ? key.toString().substring(0, Math.min(4, key.toString().length())) + "..." : "????";
            String velocity = class_3532.method_15357((double)(pearl.getVelocity().method_1033() * 20.0)) + "m/s";
            String position = String.format("(%d, %d, %d)", pearl.getIPosition().method_10263(), pearl.getIPosition().method_10264(), pearl.getIPosition().method_10260());
            return new TextBuffer().addText("Pearl: ", class_124.field_1062).addText(uuid, class_124.field_1068).addText(" Velocity: ", class_124.field_1062).addText(velocity, class_124.field_1068).addText(" Position: ", class_124.field_1062).addText(position, class_124.field_1068).build();
        }).toArray(class_2561[]::new);
    }

    public static class EnderPearlData {
        private final class_1684 entity;
        private class_243 position;
        private class_243 velocity;

        public EnderPearlData(class_1684 entity, class_243 position, class_243 velocity) {
            this.entity = entity;
            this.position = position;
            this.velocity = velocity;
        }

        public class_243 getPosition() {
            return this.position;
        }

        public class_243 getVelocity() {
            return this.velocity;
        }

        public class_2382 getIPosition() {
            return new class_2382(class_3532.method_15357((double)this.position.field_1352), class_3532.method_15357((double)this.position.field_1351), class_3532.method_15357((double)this.position.field_1350));
        }

        public class_2382 getIVelocity() {
            return new class_2382(class_3532.method_15357((double)this.velocity.field_1352), class_3532.method_15357((double)this.velocity.field_1351), class_3532.method_15357((double)this.velocity.field_1350));
        }

        public void updatePositionAndVelocity(class_243 position, class_243 velocity) {
            this.position = position;
            this.velocity = velocity;
        }

        public String toString() {
            return "Entity: " + this.entity.method_5845() + "\nPosition: " + String.valueOf(this.getPosition()) + "\nVelocity: " + String.valueOf(this.getVelocity());
        }
    }
}

