/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.common.counter;

import carpettisaddition.commands.AbstractCommand;
import carpettisaddition.commands.CommandTreeContext;
import carpettisaddition.commands.common.counter.DyeCounter;
import carpettisaddition.commands.common.counter.DyeCounterKey;
import carpettisaddition.commands.common.counter.DyeCounterProvider;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.CarpetModUtil;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.command.SimpleCommandBuilder;
import com.google.common.collect.Maps;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1767;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DyeCounterCommand<Key extends DyeCounterKey, Counter extends DyeCounter<Key>>
extends AbstractCommand
implements DyeCounterProvider<Key, DyeCounter<Key>> {
    public static final List<String> COLORS = Arrays.stream(class_1767.values()).map(cl -> cl.method_7792().toLowerCase()).collect(Collectors.toList());
    protected final Map<class_1767, Counter> counter = Maps.newEnumMap(class_1767.class);
    protected final String commandPrefix;
    private final Translator baseTr = new Translator("command.dye_counter");

    public DyeCounterCommand(String name, String commandPrefix) {
        super(name);
        this.commandPrefix = commandPrefix;
        for (class_1767 color : class_1767.values()) {
            this.counter.put(color, this.createCounterForColor(color));
        }
    }

    @Override
    @NotNull
    public Counter getCounter(@NotNull class_1767 color) {
        return (Counter)((DyeCounter)this.counter.get(Objects.requireNonNull(color)));
    }

    @Override
    @Nullable
    public Counter getCounter(String color) {
        class_1767 dyeColor;
        try {
            dyeColor = class_1767.valueOf((String)color.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return this.getCounter(dyeColor);
    }

    protected abstract Counter createCounterForColor(class_1767 var1);

    protected abstract Object getRuleValue();

    protected abstract boolean isActivated();

    protected void addFor(class_1767 color, Key key, long count) {
        ((DyeCounter)this.counter.get(color)).addForKey(key, count);
    }

    @Override
    public void registerCommand(CommandTreeContext.Register context) {
        String NAME = this.commandPrefix;
        SimpleCommandBuilder builder = new SimpleCommandBuilder();
        builder.command(NAME, c -> this.reportAll((class_2168)c.getSource()));
        builder.command(NAME + " reset", c -> this.resetAll((class_2168)c.getSource()));
        builder.command(NAME + " <color>", c -> this.report((class_2168)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"color"), false));
        builder.command(NAME + " <color> realtime", c -> this.report((class_2168)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"color"), true));
        builder.command(NAME + " <color> reset", c -> this.resetSingle((class_2168)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"color")));
        builder.literal(NAME).requires(s -> CarpetModUtil.canUseCommand(s, this.getRuleValue()));
        builder.argument("<color>", StringArgumentType.word()).suggests((c, b) -> class_2172.method_9265(COLORS, (SuggestionsBuilder)b));
        builder.registerCommand(context);
    }

    private int report(class_2168 source, String color, boolean realtime) {
        return this.doWithCounter(source, color, counter -> {
            Messenger.tell(source, counter.report(realtime));
            return 1;
        });
    }

    private int reportAll(class_2168 source) {
        int printed = 0;
        for (DyeCounter counter : this.counter.values()) {
            List<class_5250> lines = counter.report(false);
            if (lines.size() <= 1) continue;
            Messenger.tell(source, Messenger.s(""));
            ++printed;
            Messenger.tell(source, lines);
        }
        if (printed == 0) {
            Messenger.tell(source, this.baseTr.tr("no_item_yet", this.tr("key_name", new Object[0])));
        }
        return printed;
    }

    private int doWithCounter(class_2168 source, String color, Function<Counter, Integer> consumer) {
        return Optional.ofNullable(this.getCounter(color)).map(consumer).orElseGet(() -> {
            Messenger.tell(source, this.baseTr.tr("unknown_color", color));
            return 0;
        });
    }

    private int resetAll(class_2168 source) {
        for (DyeCounter counter : this.counter.values()) {
            counter.reset();
        }
        Messenger.tell(source, this.baseTr.tr("restart_all", this.tr("counter_name", new Object[0])), true);
        return 1;
    }

    private int resetSingle(class_2168 source, String color) {
        return this.doWithCounter(source, color, counter -> {
            counter.reset();
            Messenger.tell(source, this.baseTr.tr("restart_single", counter.getColorText(), this.tr("counter_name", new Object[0])), true);
            return 1;
        });
    }
}

