/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.lifetime.recorder;

import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.commands.lifetime.recorder.Record;
import carpettisaddition.utils.FileUtils;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

class RecordWriterThread
implements AutoCloseable {
    private static final AtomicLong counter = new AtomicLong();
    private static final byte[] SYSTEM_LINE_SEP = System.lineSeparator().getBytes(StandardCharsets.UTF_8);
    private final Path outputFile;
    private final long maxOutputRecordCount;
    private final long maxOutputFileBytes;
    private final StopCallback stopCallback;
    private final Thread thread;
    private final BlockingQueue<Record> writeQueue = new LinkedBlockingQueue<Record>(10000);
    private final AtomicLong recordWritten = new AtomicLong(0L);
    private final AtomicLong bytesWritten = new AtomicLong(0L);
    private final AtomicBoolean working = new AtomicBoolean(true);

    public RecordWriterThread(Path outputFile, long maxOutputRecordCount, long maxOutputFileBytes, StopCallback stopCallback) {
        this.outputFile = outputFile;
        this.maxOutputRecordCount = maxOutputRecordCount;
        this.maxOutputFileBytes = maxOutputFileBytes;
        this.stopCallback = stopCallback;
        this.thread = new Thread(this::writerThreadImpl);
        this.thread.setName("tiscm-lifetime-record-writer-" + counter.getAndIncrement());
        this.thread.start();
    }

    public void write(Record record) {
        if (this.working.get()) {
            this.writeQueue.offer(record);
        }
    }

    public boolean isFileLimitExceeded() {
        return this.maxOutputRecordCount > 0L && this.getRecordWritten() >= this.maxOutputRecordCount || this.maxOutputFileBytes > 0L && this.getBytesWritten() >= this.maxOutputFileBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writerThreadImpl() {
        FilterOutputStream writer = null;
        try {
            FileUtils.touchFileDirectory(this.outputFile);
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    Record record = this.writeQueue.take();
                    byte[] line = record.toJson().getBytes(StandardCharsets.UTF_8);
                    if (writer == null) {
                        writer = new BufferedOutputStream(Files.newOutputStream(this.outputFile, new OpenOption[0]));
                    }
                    writer.write(line);
                    writer.write(SYSTEM_LINE_SEP);
                    ((BufferedOutputStream)writer).flush();
                    this.recordWritten.addAndGet(1L);
                    this.bytesWritten.addAndGet(line.length + SYSTEM_LINE_SEP.length);
                    if (!this.isFileLimitExceeded()) continue;
                    CarpetTISAdditionMod.LOGGER.info("File limit exceeded (cnt {} / {}, size {} / {}), recording stopped", new Object[]{this.maxOutputRecordCount, this.recordWritten.get(), this.maxOutputFileBytes, this.bytesWritten.get()});
                    break;
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            CarpetTISAdditionMod.LOGGER.error("Error while writing lifetime record output to file {}", (Object)this.outputFile, (Object)e);
        }
        finally {
            this.working.set(false);
            this.writeQueue.clear();
            this.stopCallback.onStop(this);
        }
    }

    @Override
    public void close() {
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Path getOutputFile() {
        return this.outputFile;
    }

    public long getRecordWritten() {
        return this.recordWritten.get();
    }

    public long getBytesWritten() {
        return this.bytesWritten.get();
    }

    @FunctionalInterface
    static interface StopCallback {
        public void onStop(RecordWriterThread var1);
    }
}

