/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.manipulate.block;

import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.commands.manipulate.block.BlockManipulator;
import carpettisaddition.mixins.command.manipulate.block.FillCommandAccessor;
import carpettisaddition.translations.TranslationContext;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.PositionUtils;
import carpettisaddition.utils.TextUtils;
import com.google.common.collect.Lists;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.class_2168;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3341;

public class BlockExecutor
extends TranslationContext {
    private final ExecuteImpl impl;
    private final int limit;
    private final String messageKey;
    private final MessageExtraArgsGetter messageExtraArgsGetter;

    public BlockExecutor(ExecuteImpl impl, int limit, String messageKey, MessageExtraArgsGetter messageExtraArgsGetter) {
        super(BlockManipulator.getInstance().getTranslator());
        this.impl = impl;
        this.limit = limit;
        this.messageKey = messageKey;
        this.messageExtraArgsGetter = messageExtraArgsGetter;
    }

    public BlockExecutor(ExecuteImpl impl, String messageKey, MessageExtraArgsGetter messageExtraArgsGetter) {
        this(impl, CarpetTISAdditionSettings.manipulateBlockLimit, messageKey, messageExtraArgsGetter);
    }

    public int process(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2338 from = class_2262.method_9696(ctx, (String)"from");
        class_2338 to = class_2262.method_9696(ctx, (String)"to");
        class_3341 box = PositionUtils.createBlockBox(from, to);
        long blockCountF = (long)box.method_14660() * (long)box.method_14663();
        long blockCount = (long)box.method_14660() * (long)box.method_14663() * (long)box.method_14663();
        if (blockCountF > (long)this.limit || blockCount > (long)this.limit) {
            throw FillCommandAccessor.getTooBigException().create((Object)this.limit, (Object)blockCount);
        }
        class_2338.method_20437((class_2338)from, (class_2338)to).forEach(blockPos -> this.impl.executeAt(ctx, (class_2338)blockPos));
        String hoverText = TextUtils.coord((class_2382)from) + " -> " + TextUtils.coord((class_2382)to);
        ArrayList trArgs = Lists.newArrayList();
        trArgs.add(blockCount);
        Collections.addAll(trArgs, this.messageExtraArgsGetter.get(ctx));
        Messenger.tell((class_2168)ctx.getSource(), Messenger.fancy(this.tr(this.messageKey, trArgs.toArray()), Messenger.s(hoverText), Messenger.ClickEvents.suggestCommand(hoverText)));
        return (int)blockCount;
    }

    @FunctionalInterface
    public static interface ExecuteImpl {
        public void executeAt(CommandContext<class_2168> var1, class_2338 var2);
    }

    @FunctionalInterface
    public static interface MessageExtraArgsGetter {
        public static final MessageExtraArgsGetter NONE = ctx -> new Object[0];

        public Object[] get(CommandContext<class_2168> var1);
    }
}

