/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.manipulate.chunk;

import carpettisaddition.commands.manipulate.chunk.ChunkManipulatorUtils;
import carpettisaddition.translations.TranslationContext;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.PositionUtils;
import carpettisaddition.utils.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3227;

public class ChunkRelighter
extends TranslationContext {
    private final class_3218 world;
    private final List<class_1923> chunkPosList;
    private final class_2168 source;
    private final List<class_2818> chunks;

    protected ChunkRelighter(Translator translator, List<class_1923> chunkPosList, class_2168 source) {
        super(translator);
        this.world = source.method_9225();
        this.chunkPosList = chunkPosList;
        this.source = source;
        this.chunks = Lists.newArrayList();
    }

    public CompletableFuture<Void> relight() {
        long startTime = System.currentTimeMillis();
        for (class_1923 chunkPos : this.chunkPosList) {
            this.chunks.add(this.world.method_8497(PositionUtils.chunkPosX(chunkPos), PositionUtils.chunkPosZ(chunkPos)));
        }
        ArrayList relightFutures = Lists.newArrayList();
        for (class_2818 chunk : this.chunks) {
            relightFutures.add(this.relightOneChunk(chunk));
        }
        Messenger.tell(this.source, this.tr("relighting", this.chunkPosList.size()));
        return CompletableFuture.allOf(relightFutures.toArray(new CompletableFuture[0])).thenRunAsync(() -> {
            double costSec = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            for (class_1923 chunkPos : this.chunkPosList) {
                this.refreshChunkLight(chunkPos);
            }
            Messenger.tell(this.source, this.tr("done", this.chunkPosList.size(), StringUtils.fractionDigit(costSec, 1)));
            Messenger.tell(this.source, this.tr("hint", new Object[0]));
        }, (Executor)this.source.method_9211());
    }

    public CompletableFuture<Void> relightOneChunk(class_2818 chunk) {
        class_3227 lightingProvider = this.world.method_14178().method_17293();
        class_1923 chunkPos = chunk.method_12004();
        int startX = chunkPos.method_8326();
        int endX = chunkPos.method_8327();
        int startZ = chunkPos.method_8328();
        int endZ = chunkPos.method_8329();
        int startY = chunk.method_31607();
        int endY = chunk.method_12031() + 16 - 1;
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                for (int y = endY; y >= startY; --y) {
                    lightingProvider.method_15513(new class_2338(x, y, z));
                }
            }
        }
        return ChunkManipulatorUtils.enqueueDummyLightingTask(lightingProvider, chunkPos).thenRunAsync(() -> this.refreshChunkLight(chunkPos), (Executor)this.world.method_8503());
    }

    private void refreshChunkLight(class_1923 chunkPos) {
        ChunkManipulatorUtils.refreshChunkLight(this.world, chunkPos);
    }
}

