/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.manipulate.chunk;

import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.commands.manipulate.chunk.ChunkManipulator;
import carpettisaddition.translations.TranslationContext;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.PositionUtils;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2262;

class ThrottledOperator
extends TranslationContext {
    private final Semaphore semaphore = new Semaphore(1);
    private final OperateImpl operateImpl;

    public ThrottledOperator(ChunkManipulator chunkManipulator, OperateImpl operateImpl) {
        super(chunkManipulator.getTranslator());
        this.operateImpl = operateImpl;
    }

    public int operate(class_2168 source, List<class_1923> chunkPosList) {
        if (!this.semaphore.tryAcquire()) {
            Messenger.tell(source, this.tr("common.throttled", new Object[0]));
            return 0;
        }
        try {
            return this.operateImpl.call(source, chunkPosList, this.semaphore::release);
        }
        catch (Throwable e) {
            CarpetTISAdditionMod.LOGGER.error("Manipulation error", e);
            this.semaphore.release();
            throw e;
        }
    }

    public int operateAt(class_2168 source, class_1923 chunkPos) throws CommandSyntaxException {
        if (!source.method_9225().method_8393(PositionUtils.chunkPosX(chunkPos), PositionUtils.chunkPosZ(chunkPos))) {
            throw class_2262.field_10703.create();
        }
        return this.operate(source, Collections.singletonList(chunkPos));
    }

    public int operateInSquare(class_2168 source, int radius) {
        class_1923 center = PositionUtils.flooredChunkPos(PositionUtils.flooredBlockPos(source.method_9222()));
        List<class_1923> chunkPosList = class_1923.method_19280((class_1923)center, (int)radius).collect(Collectors.toList());
        return this.operate(source, chunkPosList);
    }

    public int operateInCircle(class_2168 source, int radius) {
        class_1923 center = PositionUtils.flooredChunkPos(PositionUtils.flooredBlockPos(source.method_9222()));
        List<class_1923> chunkPosList = class_1923.method_19280((class_1923)center, (int)radius).filter(chunkPos -> {
            int dz2;
            int dx2 = (PositionUtils.chunkPosX(chunkPos) - PositionUtils.chunkPosX(center)) * (PositionUtils.chunkPosX(chunkPos) - PositionUtils.chunkPosX(center));
            return dx2 + (dz2 = (PositionUtils.chunkPosZ(chunkPos) - PositionUtils.chunkPosZ(center)) * (PositionUtils.chunkPosZ(chunkPos) - PositionUtils.chunkPosZ(center))) <= radius * radius;
        }).collect(Collectors.toList());
        return this.operate(source, chunkPosList);
    }

    public int operateCurrent(class_2168 source) {
        return this.operateInCircle(source, 0);
    }

    @FunctionalInterface
    public static interface OperateImpl {
        public int call(class_2168 var1, List<class_1923> var2, Runnable var3);
    }
}

