/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.manipulate.container.controller;

import carpettisaddition.commands.CommandTreeContext;
import carpettisaddition.commands.manipulate.container.controller.AbstractContainerController;
import carpettisaddition.utils.Messenger;
import com.mojang.brigadier.builder.ArgumentBuilder;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3218;

public abstract class AbstractEntityListController
extends AbstractContainerController {
    public AbstractEntityListController(String translationName) {
        super(translationName);
    }

    protected abstract int processWholeList(class_3218 var1, Consumer<List<?>> var2);

    public int revert(class_2168 source) {
        return this.manipulate(source, () -> {
            int size = this.processWholeList(source.method_9225(), Collections::reverse);
            Messenger.tell(source, this.tr("revert", this.getName(), size), true);
        });
    }

    public int shuffle(class_2168 source) {
        return this.manipulate(source, () -> {
            int size = this.processWholeList(source.method_9225(), Collections::shuffle);
            Messenger.tell(source, this.tr("shuffle", this.getName(), size), true);
        });
    }

    protected abstract boolean canManipulate(class_3218 var1);

    protected int manipulate(class_2168 source, Runnable task) {
        if (this.canManipulate(source.method_9225())) {
            task.run();
            return 1;
        }
        Messenger.tell(source, basicTranslator.tr("cannot_manipulate", this.getName()));
        return 0;
    }

    @Override
    public ArgumentBuilder<class_2168, ?> getCommandNode(CommandTreeContext context) {
        return super.getCommandNode(context).then(class_2170.method_9247((String)"shuffle").executes(c -> this.shuffle((class_2168)c.getSource()))).then(class_2170.method_9247((String)"revert").executes(c -> this.revert((class_2168)c.getSource())));
    }
}

