/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.raycast;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2269;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class RaycastSimulator {
    private static final class_2680 AIR = class_2246.field_10124.method_9564();
    private static final class_2680 FLOOR = class_2246.field_10360.method_9564();
    private static final class_2680 FLOOR2 = class_2246.field_10107.method_9564();
    private static final class_2680 MELON = class_2246.field_46283.method_9564();
    private static final class_2680 CENTER = (class_2680)class_2246.field_10494.method_9564().method_11657((class_2769)class_2269.field_11007, (Comparable)class_2738.field_12475);
    private static final class_2680 BARRIER = class_2246.field_10289.method_9564();
    private static final class_2680 PARTIAL = class_2246.field_10536.method_9564();
    private final class_1937 world;
    private final class_1297 entity;

    public RaycastSimulator(class_1937 world, class_1297 entity) {
        this.world = world;
        this.entity = entity;
    }

    private boolean canTraceMelon(class_2338 start, class_2338 end) {
        class_3965 result = this.world.method_17742(new class_3959(new class_243((double)start.method_10263() + 0.5, (double)start.method_10264() + 0.5, (double)start.method_10260() + 0.5), new class_243((double)end.method_10263() + 0.5, (double)end.method_10264() + 0.5, (double)end.method_10260() + 0.5), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, this.entity));
        if (result.method_17783() == class_239.class_240.field_1332) {
            return this.world.method_8320(result.method_17777()).method_26204() == MELON.method_26204();
        }
        return false;
    }

    private void simulate1Layer(class_2338 centerPos, int r) {
        this.world.method_8501(centerPos, CENTER);
        for (class_2338 pos2 : class_2338.method_10097((class_2338)centerPos.method_10069(-r, -1, -r), (class_2338)centerPos.method_10069(r, -1, r))) {
            this.world.method_8501(pos2, FLOOR);
        }
        for (class_2338 pos2 : class_2338.method_10097((class_2338)centerPos.method_10069(-r, 0, -r), (class_2338)centerPos.method_10069(r, 0, r))) {
            this.world.method_8501(pos2, AIR);
        }
        ArrayList melonPos = Lists.newArrayList((Object[])new class_2338[]{centerPos.method_10069(-r, 0, -r), centerPos.method_10069(-r, 0, r), centerPos.method_10069(r, 0, -r), centerPos.method_10069(r, 0, r)});
        melonPos.forEach(pos -> this.world.method_8501(pos, MELON));
        Supplier<Long> counter = () -> melonPos.stream().filter(pos -> this.canTraceMelon(centerPos, (class_2338)pos)).count();
        for (class_2338 pos3 : class_2338.method_10097((class_2338)centerPos.method_10069(-r, 0, -r), (class_2338)centerPos.method_10069(r, 0, r))) {
            if (!this.world.method_8320(pos3).method_26215()) continue;
            this.world.method_8501(pos3, BARRIER);
            Long count = counter.get();
            if (count >= (long)melonPos.size()) continue;
            this.world.method_8501(pos3, AIR);
        }
    }

    public void simulate(class_2338 startPos, int maxR) {
        class_2338 pos = startPos;
        for (int r = 1; r <= maxR; ++r) {
            this.simulate1Layer(pos, r);
            if (r >= maxR) continue;
            pos = pos.method_10069(0, 0, r * 2 + 4);
        }
        for (class_2338 p : class_2338.method_10097((class_2338)startPos.method_10069(-maxR - 1, -1, -2), (class_2338)pos.method_10069(maxR + 1, -1, maxR + 1))) {
            if (!this.world.method_8320(p).method_26215()) continue;
            this.world.method_8501(p, FLOOR2);
        }
    }
}

