/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.speedtest;

import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.commands.AbstractCommand;
import carpettisaddition.commands.CommandTreeContext;
import carpettisaddition.commands.speedtest.SpeedTestReporter;
import carpettisaddition.commands.speedtest.TestType;
import carpettisaddition.commands.speedtest.ping.PongReceiver;
import carpettisaddition.commands.speedtest.session.SpeedTestClientSessionHolder;
import carpettisaddition.commands.speedtest.session.SpeedTestServerSession;
import carpettisaddition.commands.speedtest.session.SpeedTestServerSessionHolder;
import carpettisaddition.commands.speedtest.tester.SpeedTestClientUploader;
import carpettisaddition.commands.speedtest.tester.SpeedTestDownloader;
import carpettisaddition.commands.speedtest.tester.SpeedTestPinger;
import carpettisaddition.commands.speedtest.tester.SpeedTestServerUploadReceiver;
import carpettisaddition.commands.speedtest.tester.SpeedTester;
import carpettisaddition.network.HandlerContext;
import carpettisaddition.network.TISCMClientPacketHandler;
import carpettisaddition.network.TISCMProtocol;
import carpettisaddition.network.TISCMServerPacketHandler;
import carpettisaddition.utils.CarpetModUtil;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.NbtUtils;
import carpettisaddition.utils.command.SimpleCommandBuilder;
import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class SpeedTestCommand
extends AbstractCommand {
    public static final String NAME = "speedtest";
    private static final SpeedTestCommand INSTANCE = new SpeedTestCommand();
    private final SpeedTestClientSessionHolder clientSessionHolder = new SpeedTestClientSessionHolder();
    private final SpeedTestServerSessionHolder serverSessionHolder = new SpeedTestServerSessionHolder();

    public SpeedTestCommand() {
        super(NAME);
    }

    public static SpeedTestCommand getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerCommand(CommandTreeContext.Register context) {
        SimpleCommandBuilder builder = new SimpleCommandBuilder();
        builder.command(NAME, c -> this.showHelp((class_2168)c.getSource()));
        builder.command("speedtest download", c -> this.testDownload((class_2168)c.getSource(), Math.min(10, CarpetTISAdditionSettings.speedTestCommandMaxTestSize)));
        builder.command("speedtest download <size_mib>", c -> this.testDownload((class_2168)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"size_mib")));
        builder.command("speedtest upload", c -> this.testUpload((class_2168)c.getSource(), Math.min(10, CarpetTISAdditionSettings.speedTestCommandMaxTestSize)));
        builder.command("speedtest upload <size_mib>", c -> this.testUpload((class_2168)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"size_mib")));
        builder.command("speedtest ping", c -> this.testPing((class_2168)c.getSource(), 3, 1.0));
        builder.command("speedtest ping <count>", c -> this.testPing((class_2168)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"count"), 1.0));
        builder.command("speedtest ping <count> <interval>", c -> this.testPing((class_2168)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"count"), DoubleArgumentType.getDouble((CommandContext)c, (String)"interval")));
        builder.command("speedtest abort", c -> this.abortTest((class_2168)c.getSource()));
        builder.literal(NAME).requires(s -> CarpetModUtil.canUseCommand(s, CarpetTISAdditionSettings.commandSpeedTest));
        builder.argument("<size_mib>", IntegerArgumentType.integer((int)1));
        builder.argument("<count>", IntegerArgumentType.integer((int)1));
        builder.argument("<interval>", DoubleArgumentType.doubleArg((double)0.0, (double)10.0));
        builder.registerCommand(context);
    }

    public void onServerClosed() {
        this.clientSessionHolder.reset();
        this.serverSessionHolder.reset();
    }

    public void onPlayerDisconnected(class_3222 player) {
        this.serverSessionHolder.abortAndClearFor(player);
    }

    private int showHelp(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ArrayList idToCheck = Lists.newArrayList((Object[])new TISCMProtocol.S2C[]{TISCMProtocol.S2C.SPEED_TEST_DOWNLOAD_PAYLOAD, TISCMProtocol.S2C.SPEED_TEST_UPLOAD_REQUEST, TISCMProtocol.S2C.SPEED_TEST_PING, TISCMProtocol.S2C.SPEED_TEST_ABORT});
        int cnt = idToCheck.stream().mapToInt(id -> {
            boolean ok = TISCMServerPacketHandler.getInstance().doesClientSupport(player.field_13987, (TISCMProtocol.S2C)id);
            return ok ? 1 : 0;
        }).sum();
        class_5250 supportState = cnt == 0 ? Messenger.formatting(this.tr("help.support_state.no", new Object[0]), class_124.field_1061) : (cnt < idToCheck.size() ? Messenger.formatting(this.tr("help.support_state.partial", new Object[0]), class_124.field_1054) : Messenger.formatting(this.tr("help.support_state.yes", new Object[0]), class_124.field_1060));
        Messenger.tell((class_1657)player, this.tr("help", Messenger.hover(Messenger.s(String.valueOf(CarpetTISAdditionSettings.speedTestCommandMaxTestSize)), this.tr("help.test_size_rule_hint", new Object[0])), supportState));
        return 0;
    }

    private int abortTest(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        SpeedTestServerSession session = this.serverSessionHolder.getFor(player);
        if (session == null) {
            Messenger.tell(source, this.tr("command.abort_no_test", new Object[0]));
            return 0;
        }
        session.getMessenger().sendMessage(this.tr("command.abort_test", new Object[0]), false);
        this.serverSessionHolder.abortAndClearFor(player);
        return 1;
    }

    private int testDownload(class_2168 source, int testSizeMb) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        if (!this.checkSpeedTestRequirements(player, testSizeMb, TISCMProtocol.S2C.SPEED_TEST_DOWNLOAD_PAYLOAD)) {
            return 0;
        }
        new SpeedTestDownloader(player, testSizeMb, this.serverSessionHolder, new SpeedTestReporter(TestType.DOWNLOAD, source)).start();
        return 1;
    }

    private int testUpload(class_2168 source, int testSizeMb) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        if (!this.checkSpeedTestRequirements(player, testSizeMb, TISCMProtocol.S2C.SPEED_TEST_UPLOAD_REQUEST)) {
            return 0;
        }
        new SpeedTestServerUploadReceiver(player, testSizeMb, this.serverSessionHolder, new SpeedTestReporter(TestType.UPLOAD, source)).start();
        return 1;
    }

    private int testPing(class_2168 source, int count, double interval) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        if (!this.checkSpeedTestRequirements(player, null, TISCMProtocol.S2C.SPEED_TEST_PING)) {
            return 0;
        }
        new SpeedTestPinger(source, player, count, interval, this.serverSessionHolder).start();
        return 1;
    }

    private boolean checkSpeedTestRequirements(class_3222 player, @Nullable Integer testSizeMb, TISCMProtocol.S2C ... packetIds) {
        if (testSizeMb != null && testSizeMb > CarpetTISAdditionSettings.speedTestCommandMaxTestSize) {
            Messenger.tell((class_1657)player, this.tr("command.test_size_too_large", testSizeMb, CarpetTISAdditionSettings.speedTestCommandMaxTestSize));
            return false;
        }
        if (!CarpetTISAdditionSettings.tiscmNetworkProtocol) {
            Messenger.tell((class_1657)player, this.tr("command.tiscm_protocol_disabled", new Object[0]));
            return false;
        }
        for (TISCMProtocol.S2C packetId : packetIds) {
            if (TISCMServerPacketHandler.getInstance().doesClientSupport(player.field_13987, packetId)) continue;
            Messenger.tell((class_1657)player, this.tr("command.client_not_supported", new Object[0]));
            return false;
        }
        if (this.serverSessionHolder.getFor(player) != null) {
            Messenger.tell((class_1657)player, this.tr("command.has_ongoing", new Object[0]));
            return false;
        }
        return true;
    }

    public void handleServerUploadRequest(HandlerContext.S2C ctx) {
        int testSizeMb = NbtUtils.getIntOrZero(ctx.payload, "size_mb");
        if (this.clientSessionHolder.getUploader() != null) {
            CarpetTISAdditionMod.LOGGER.error("Received upload speed test request, but there's ongoing test. Overriding");
        }
        CarpetTISAdditionMod.LOGGER.info("Starting upload speed test, test size = {}MiB", (Object)testSizeMb);
        new SpeedTestClientUploader(testSizeMb, this.clientSessionHolder).start();
    }

    public void handleServerPing(HandlerContext.S2C ctx) {
        String pingType;
        switch (pingType = NbtUtils.getStringOrEmpty(ctx.payload, "type")) {
            case "ping": {
                TISCMClientPacketHandler.getInstance().sendPacket(TISCMProtocol.C2S.SPEED_TEST_PING, nbt -> {
                    nbt.method_10543(ctx.payload);
                    nbt.method_10582("type", "pong");
                });
                break;
            }
            case "pong": {
                SpeedTester tester = this.clientSessionHolder.getUploader();
                if (!(tester instanceof PongReceiver)) break;
                ((PongReceiver)((Object)tester)).onPongReceived(ctx.payload);
                break;
            }
            default: {
                CarpetTISAdditionMod.LOGGER.warn("Received unknown ping type '{}' from server", (Object)pingType);
            }
        }
    }

    public void handleServerTestAbort(HandlerContext.S2C ctx) {
        this.clientSessionHolder.abortAndClear();
    }

    public void handleClientSpeedTestUploadPayload(HandlerContext.C2S ctx) {
        SpeedTestServerSession tester = this.serverSessionHolder.getFor(ctx.player);
        if (tester instanceof SpeedTestServerUploadReceiver) {
            ((SpeedTestServerUploadReceiver)tester).onC2SPayloadPacketReceived();
        }
    }

    public void handleClientPing(HandlerContext.C2S ctx) {
        String pingType;
        switch (pingType = NbtUtils.getStringOrEmpty(ctx.payload, "type")) {
            case "ping": {
                TISCMServerPacketHandler.getInstance().sendPacket(ctx.networkHandler, TISCMProtocol.S2C.SPEED_TEST_PING, nbt -> {
                    nbt.method_10543(ctx.payload);
                    nbt.method_10582("type", "pong");
                });
                break;
            }
            case "pong": {
                SpeedTestServerSession tester = this.serverSessionHolder.getFor(ctx.player);
                if (!(tester instanceof PongReceiver)) break;
                ((PongReceiver)((Object)tester)).onPongReceived(ctx.payload);
                break;
            }
            default: {
                CarpetTISAdditionMod.LOGGER.warn("Received unknown ping type '{}' from client", (Object)pingType);
            }
        }
    }
}

