/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.speedtest;

import carpettisaddition.commands.speedtest.SpeedTestCommand;
import carpettisaddition.commands.speedtest.TestType;
import carpettisaddition.commands.speedtest.session.SpeedTestSessionMessenger;
import carpettisaddition.commands.speedtest.session.SpeedTestSessionMessengerImpl;
import carpettisaddition.translations.TranslationContext;
import carpettisaddition.utils.Messenger;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class SpeedTestReporter
extends TranslationContext
implements SpeedTestSessionMessenger {
    private static final double BYTES_PER_MB = 1048576.0;
    private static final int BAR_WIDTH = 40;
    private final SpeedTestSessionMessenger messenger;
    private long lastReportNs = -1L;

    public SpeedTestReporter(TestType testType, class_2168 source) {
        super(SpeedTestCommand.getInstance().getTranslator().getDerivedTranslator("speed_test"));
        this.messenger = new SpeedTestSessionMessengerImpl(testType, source);
    }

    @Override
    public void sendMessage(class_5250 message, boolean withCancelButton) {
        this.messenger.sendMessage(message, withCancelButton);
    }

    public void start(long totalBytes) {
        this.lastReportNs = System.nanoTime();
        this.sendMessage(this.tr("start", Math.round((double)totalBytes / 1048576.0)), true);
    }

    public void onProgress(long timeCostNs, long processedBytes, long totalBytes) {
        long currentNs = System.nanoTime();
        if ((double)(currentNs - this.lastReportNs) >= 1.0E9) {
            this.reportProgress(timeCostNs, processedBytes, totalBytes);
            this.lastReportNs = currentNs;
        }
    }

    public void reportProgress(long timeCostNs, long processedBytes, long totalBytes) {
        double percent = class_3532.method_15350((double)(100.0 * (double)processedBytes / (double)totalBytes), (double)0.0, (double)100.0);
        ArrayList list = Lists.newArrayList();
        for (int i = 1; i <= 40; ++i) {
            list.add(percent >= (double)i * 100.0 / 40.0 ? Messenger.s("#") : Messenger.s((Object)"-", class_124.field_1063));
        }
        class_5250 bar = Messenger.c(list.toArray(new Object[0]));
        double timeCostSec = (double)Math.max(1L, timeCostNs) / 1.0E9;
        double mbps = (double)processedBytes / timeCostSec / 1048576.0;
        this.sendMessage(this.tr("progress", bar, String.valueOf(Math.round(percent)), String.format("%.2f", mbps)), true);
    }

    public void reportDone(long timeCostNs, long processedBytes, long totalBytes) {
        double timeCostSec = (double)Math.max(1L, timeCostNs) / 1.0E9;
        double mb = (double)processedBytes / 1048576.0;
        double mbps = mb / timeCostSec;
        String mbStr = mb == (double)((long)mb) ? String.format("%d", (long)mb) : String.format("%.2f", mb);
        this.sendMessage(this.tr("done", mbStr, String.format("%.2f", timeCostSec), String.format("%.2f", mbps)), false);
    }
}

