/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.helpers.rule.persistentLoggerSubscription;

import carpet.logging.Logger;
import carpet.logging.LoggerRegistry;
import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.helpers.carpet.loggerRestriction.CarpetLoggerRestriction;
import carpettisaddition.helpers.rule.persistentLoggerSubscription.DataStorage;
import carpettisaddition.utils.FileUtils;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1657;
import org.jetbrains.annotations.Nullable;

public class LoggerSubscriptionStorage {
    public static final String STORAGE_FILE_PATH = String.format("./config/%s/logger_subscriptions.json", CarpetTISAdditionServer.compactName);
    private static final LoggerSubscriptionStorage INSTANCE = new LoggerSubscriptionStorage();
    private static final ThreadPoolExecutor FILE_SAVE_POOL = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), new ThreadFactoryBuilder().setNameFormat(LoggerSubscriptionStorage.class.getSimpleName() + " IO").build(), new ThreadPoolExecutor.DiscardOldestPolicy());
    private DataStorage storage = null;

    public static LoggerSubscriptionStorage getInstance() {
        return INSTANCE;
    }

    public void load() {
        this.storage = null;
        File file = new File(STORAGE_FILE_PATH);
        if (FileUtils.isFile(file)) {
            try (InputStreamReader isr = new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                this.storage = (DataStorage)new Gson().fromJson((Reader)isr, DataStorage.class);
            }
            catch (Exception e) {
                CarpetTISAdditionServer.LOGGER.error("Failed to read logger subscription storage file", (Throwable)e);
            }
        }
        if (this.storage == null) {
            this.storage = new DataStorage();
            this.save();
        }
    }

    private void save() {
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        String content = gson.toJson((Object)this.storage);
        FILE_SAVE_POOL.submit(() -> this.__save(content));
    }

    private void __save(String content) {
        File file = new File(STORAGE_FILE_PATH);
        try {
            FileUtils.touchFileDirectory(file);
        }
        catch (IOException e) {
            CarpetTISAdditionServer.LOGGER.error("Failed to create directory for logger subscription storage file", (Throwable)e);
            return;
        }
        try (BufferedWriter fw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            fw.write(content);
        }
        catch (IOException e) {
            CarpetTISAdditionServer.LOGGER.error("Failed to write logger subscription storage file", (Throwable)e);
        }
        try {
            Thread.sleep(3L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void ensureStorageExists() {
        if (this.storage == null) {
            this.load();
        }
    }

    public boolean restoreSubscription(class_1657 player) {
        this.ensureStorageExists();
        Map playerEntry = (Map)this.storage.get(player.method_5845());
        if (playerEntry != null) {
            String playerName = player.method_5477().getString();
            playerEntry.forEach((loggerName, option) -> {
                Logger logger = LoggerRegistry.getLogger((String)loggerName);
                if (logger != null) {
                    CarpetTISAdditionServer.LOGGER.debug("Restore {} {} for {}", new Object[]{loggerName, option, playerName});
                    if (CarpetLoggerRestriction.isLoggerSubscribable(logger, player, option)) {
                        LoggerRegistry.subscribePlayer((String)playerName, (String)loggerName, (String)option);
                    }
                }
            });
            return true;
        }
        return false;
    }

    private DataStorage.PlayerEntry getEntry(class_1657 player) {
        this.ensureStorageExists();
        return this.storage.computeIfAbsent(player.method_5845(), uuid -> new DataStorage.PlayerEntry());
    }

    public void addSubscription(class_1657 player, String loggerName, @Nullable String option) {
        DataStorage.PlayerEntry entry = this.getEntry(player);
        if (!entry.containsKey(loggerName) || !Objects.equals(entry.get(loggerName), option)) {
            entry.put(loggerName, option);
            this.save();
        }
    }

    public void removeSubscription(class_1657 player, String loggerName) {
        DataStorage.PlayerEntry entry = this.getEntry(player);
        if (entry.containsKey(loggerName)) {
            entry.remove(loggerName);
            this.save();
        }
    }
}

