/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.damage;

import carpettisaddition.logging.loggers.damage.DamageContext;
import carpettisaddition.utils.IdentifierUtils;
import carpettisaddition.utils.entityfilter.EntityFilter;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class OptionParser {
    private final Target fromTarget;
    private final Target toTarget;
    private final boolean matchesAny;
    private final boolean biDirection;

    public OptionParser(String option) {
        String[] parts = option.split("<->", -1);
        if (parts.length > 1) {
            this.fromTarget = Target.of(parts[0]);
            this.toTarget = Target.of(parts[1]);
            this.matchesAny = false;
            this.biDirection = true;
            return;
        }
        this.biDirection = false;
        parts = option.split("->", -1);
        if (parts.length > 1) {
            this.fromTarget = Target.of(parts[0]);
            this.toTarget = Target.of(parts[1]);
            this.matchesAny = false;
        } else {
            this.fromTarget = this.toTarget = Target.of(option);
            this.matchesAny = true;
        }
    }

    public boolean accepts(class_1657 player, DamageContext ctx) {
        if (this.biDirection) {
            return this.fromTarget.matchFrom(player, ctx.source, ctx.from) && this.toTarget.matchTo(player, ctx.source, ctx.to) || this.fromTarget.matchTo(player, ctx.source, ctx.to) && this.toTarget.matchFrom(player, ctx.source, ctx.from);
        }
        boolean fromMatches = this.fromTarget.matchFrom(player, ctx.source, ctx.from);
        boolean toMatches = this.toTarget.matchTo(player, ctx.source, ctx.to);
        return this.matchesAny ? fromMatches || toMatches : fromMatches && toMatches;
    }

    private static interface Target {
        public boolean matchFrom(class_1657 var1, class_1282 var2, @Nullable class_1297 var3);

        public boolean matchTo(class_1657 var1, class_1282 var2, @Nullable class_1297 var3);

        public static Target of(final String option) {
            class_1299 entityType;
            String namePart;
            class_2960 identifier;
            class_2960 catalogue;
            switch (option) {
                case "": 
                case "*": 
                case "all": {
                    return (player, entity) -> true;
                }
                case "me": {
                    return (player, entity) -> entity == player;
                }
                case "players": {
                    return (player, entity) -> entity instanceof class_1657;
                }
            }
            String[] parts = option.split("/", -1);
            if (parts.length == 1) {
                catalogue = null;
                identifier = class_2960.method_12829((String)parts[0]);
                namePart = parts[0];
            } else if (parts.length == 2) {
                catalogue = class_2960.method_12829((String)parts[0]);
                identifier = class_2960.method_12829((String)parts[1]);
                namePart = parts[1];
            } else {
                identifier = null;
                catalogue = null;
                namePart = option;
            }
            if ((catalogue == null || catalogue.equals((Object)IdentifierUtils.ofVanilla("entity_type"))) && identifier != null && (entityType = (class_1299)class_7923.field_41177.method_17966(identifier).orElse(null)) != null) {
                return (player, entity) -> entity != null && entity.method_5864() == entityType;
            }
            return new Target(){
                private final SimpleTarget entityFilterTarget = (player, entity) -> EntityFilter.createOptional(player, option).map(filter -> filter.test(entity)).orElse(false);

                @Override
                public boolean matchFrom(class_1657 player, class_1282 source, @Nullable class_1297 from) {
                    if ((catalogue == null || catalogue.equals((Object)IdentifierUtils.ofVanilla("damage_name"))) && Objects.equals(source.method_5525(), namePart)) {
                        return true;
                    }
                    if (catalogue == null || catalogue.equals((Object)IdentifierUtils.ofVanilla("damage_type"))) {
                        class_2960 sourceId = source.method_48793().method_40230().map(k -> k.method_29177()).orElse(null);
                        if (identifier != null && Objects.equals(sourceId, identifier)) {
                            return true;
                        }
                    }
                    return this.entityFilterTarget.matchFrom(player, source, from);
                }

                @Override
                public boolean matchTo(class_1657 player, class_1282 source, @Nullable class_1297 to) {
                    return this.entityFilterTarget.matchTo(player, source, to);
                }
            };
        }
    }

    @FunctionalInterface
    private static interface SimpleTarget
    extends Target {
        public boolean matchEntity(class_1657 var1, @Nullable class_1297 var2);

        @Override
        default public boolean matchFrom(class_1657 player, class_1282 source, @Nullable class_1297 from) {
            return this.matchEntity(player, from);
        }

        @Override
        default public boolean matchTo(class_1657 player, class_1282 source, @Nullable class_1297 to) {
            return this.matchEntity(player, to);
        }
    }
}

