/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.message;

import carpettisaddition.logging.loggers.microtiming.MicroTimingLogger;
import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import carpettisaddition.logging.loggers.microtiming.events.BaseEvent;
import carpettisaddition.logging.loggers.microtiming.events.EventSource;
import carpettisaddition.logging.loggers.microtiming.message.MessageType;
import carpettisaddition.logging.loggers.microtiming.tickphase.TickPhase;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingContext;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingUtil;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.TextUtils;
import carpettisaddition.utils.compat.DimensionWrapper;
import carpettisaddition.utils.deobfuscator.StackTracePrinter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3611;
import net.minecraft.class_5250;

public class MicroTimingMessage {
    private static final int MAX_INDENT = 10;
    private static final int SPACE_PER_INDENT = 2;
    private static final List<String> INDENTATIONS = Lists.newArrayList();
    private final DimensionWrapper dimensionType;
    private final class_2338 pos;
    private final class_1767 color;
    private final TickPhase tickPhase;
    private final class_5250 stackTraceText;
    private final BaseEvent event;
    private final String blockName;

    public MicroTimingMessage(MicroTimingLogger logger, MicroTimingContext context) {
        this.dimensionType = DimensionWrapper.of(context.getWorld());
        this.pos = context.getBlockPos();
        this.color = context.getColor();
        this.event = context.getEventSupplier().get();
        this.blockName = context.getBlockName();
        this.tickPhase = logger.getTickPhase();
        this.stackTraceText = StackTracePrinter.makeSymbol(MicroTimingLoggerManager.class);
    }

    private static class_5250 tr(String key, Object ... args) {
        return MicroTimingLoggerManager.TRANSLATOR.tr(key, args);
    }

    public MessageType getMessageType() {
        return MessageType.fromEventType(this.event.getEventType());
    }

    public BaseEvent getEvent() {
        return this.event;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MicroTimingMessage)) {
            return false;
        }
        MicroTimingMessage message = (MicroTimingMessage)o;
        return Objects.equals(this.dimensionType, message.dimensionType) && Objects.equals(this.pos, message.pos) && this.color == message.color && Objects.equals(this.tickPhase, message.tickPhase) && Objects.equals(this.event, message.event);
    }

    public int hashCode() {
        return Objects.hash(this.dimensionType, this.pos, this.color, this.tickPhase, this.event);
    }

    private class_5250 getHashTagText(int indentation) {
        return Messenger.fancy(MicroTimingUtil.getColorStyle(this.color), Messenger.s("# "), Messenger.c(MicroTimingMessage.tr("common.position", new Object[0]), Messenger.s(": "), Messenger.coord((class_2382)this.pos), Messenger.newLine(), MicroTimingMessage.tr("common.color", new Object[0]), Messenger.s(": "), Messenger.s(this.color.toString()), Messenger.newLine(), MicroTimingMessage.tr("common.indentation", new Object[0]), Messenger.s(": "), Messenger.s(String.valueOf(indentation))), Messenger.ClickEvents.suggestCommand(TextUtils.tp((class_2382)this.pos, this.dimensionType)));
    }

    public static class_5250 getIndentationText(int indentation) {
        return Messenger.s(INDENTATIONS.get(Integer.min(indentation, 10)));
    }

    private class_5250 getEnclosedTranslatedBlockNameHeaderText() {
        EventSource eventSource = this.event.getEventSource();
        class_5250 type = Messenger.s("unknown");
        if (eventSource.getSourceObject() instanceof class_2248) {
            type = MicroTimingMessage.tr("common.block", new Object[0]);
        } else if (eventSource.getSourceObject() instanceof class_3611) {
            type = MicroTimingMessage.tr("common.fluid", new Object[0]);
        }
        return Messenger.c("g [", Messenger.fancy(null, this.blockName != null ? Messenger.s(this.blockName) : eventSource.getName(), Messenger.c(MicroTimingMessage.tr("common.event_source", new Object[0]), "w : ", eventSource.getName(), "w  (", type, "w )\n", MicroTimingMessage.tr("common.id", new Object[0]), String.format("w : %s", eventSource.getId())), null), "g ] ");
    }

    public class_5250 toText(int indentation, boolean showStage) {
        ArrayList line = Lists.newArrayList();
        if (indentation > 0) {
            line.add(MicroTimingMessage.getIndentationText(indentation));
        }
        line.add(this.getHashTagText(indentation));
        line.add(this.getEnclosedTranslatedBlockNameHeaderText());
        line.add(this.event.toText());
        if (this.event.getEventType() != EventType.ACTION_END && showStage) {
            line.add(Messenger.c("g  @ ", this.tickPhase.toText("y")));
        }
        line.add("w  ");
        line.add(this.stackTraceText);
        return Messenger.c(line.toArray(new Object[0]));
    }

    public void mergeQuitMessage(MicroTimingMessage quitMessage) {
        if (quitMessage != null) {
            this.event.mergeQuitEvent(quitMessage.event);
        }
    }

    static {
        Object indent = "";
        for (int i = 0; i <= 10; ++i) {
            INDENTATIONS.add((String)indent);
            for (int j = 0; j < 2; ++j) {
                indent = (String)indent + " ";
            }
        }
    }
}

