/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.utils;

import carpet.logging.LoggerRegistry;
import carpet.utils.WoolTool;
import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.logging.loggers.microtiming.enums.MicroTimingTarget;
import carpettisaddition.logging.loggers.microtiming.marker.MicroTimingMarkerManager;
import carpettisaddition.logging.loggers.microtiming.marker.MicroTimingMarkerType;
import carpettisaddition.logging.loggers.microtiming.utils.ActualInstantNeighborUpdater;
import carpettisaddition.mixins.logger.microtiming.tickstages.ServerWorldAccessor;
import carpettisaddition.mixins.logger.microtiming.utils.WorldAccessor;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.PositionUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2231;
import net.minecraft.class_2241;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2312;
import net.minecraft.class_2318;
import net.minecraft.class_2337;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2401;
import net.minecraft.class_2426;
import net.minecraft.class_2457;
import net.minecraft.class_2458;
import net.minecraft.class_2459;
import net.minecraft.class_2537;
import net.minecraft.class_2561;
import net.minecraft.class_2665;
import net.minecraft.class_2667;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class MicroTimingUtil {
    public static final class_2350[] DIRECTION_VALUES = class_2350.values();
    private static final Translator TRANSLATOR = MicroTimingLoggerManager.TRANSLATOR.getDerivedTranslator("util");
    private static final ImmutableMap<class_1767, String> COLOR_STYLE = new ImmutableMap.Builder().put((Object)class_1767.field_7952, (Object)"w").put((Object)class_1767.field_7946, (Object)"#F9801D").put((Object)class_1767.field_7958, (Object)"m").put((Object)class_1767.field_7951, (Object)"c").put((Object)class_1767.field_7947, (Object)"y").put((Object)class_1767.field_7961, (Object)"l").put((Object)class_1767.field_7954, (Object)"#F38BAA").put((Object)class_1767.field_7944, (Object)"f").put((Object)class_1767.field_7967, (Object)"g").put((Object)class_1767.field_7955, (Object)"q").put((Object)class_1767.field_7945, (Object)"p").put((Object)class_1767.field_7966, (Object)"v").put((Object)class_1767.field_7957, (Object)"#835432").put((Object)class_1767.field_7942, (Object)"e").put((Object)class_1767.field_7964, (Object)"r").put((Object)class_1767.field_7963, (Object)"k").build();

    public static String getColorStyle(class_1767 color) {
        return (String)COLOR_STYLE.getOrDefault((Object)color, (Object)"w");
    }

    private static class_5250 tr(String key, Object ... args) {
        return TRANSLATOR.tr(key, args);
    }

    public static class_5250 getColoredValue(Object value) {
        return Messenger.colored(value);
    }

    public static class_5250 getSuccessText(boolean value, boolean showReturnValue, class_5250 hoverExtra) {
        class_5250 hintText;
        class_5250 class_52502 = hintText = value ? Messenger.formatting(MicroTimingUtil.tr("successful", new Object[0]), "e") : Messenger.formatting(MicroTimingUtil.tr("failed", new Object[0]), "r");
        if (hoverExtra != null) {
            hintText.method_10852((class_2561)Messenger.c("w \n", hoverExtra));
        }
        if (showReturnValue) {
            hintText.method_10852((class_2561)Messenger.c("w \n", MicroTimingUtil.tr("return_value", new Object[0]), "w : ", MicroTimingUtil.getColoredValue(value)));
        }
        return value ? Messenger.fancy("e", Messenger.s("\u221a"), hintText, null) : Messenger.fancy("r", Messenger.s("\u00d7"), hintText, null);
    }

    public static class_5250 getSuccessText(boolean bool, boolean showReturnValue) {
        return MicroTimingUtil.getSuccessText(bool, showReturnValue, null);
    }

    private static boolean isPositionAvailable(class_1937 world, class_2338 pos) {
        return world instanceof class_3218 && ((ServerWorldAccessor)world).invokeIsTickingFutureReady(PositionUtils.packChunkPos(pos));
    }

    public static boolean isBlockUpdateInstant(class_1937 world) {
        return ((WorldAccessor)world).getNeighborUpdater$TISCM() instanceof ActualInstantNeighborUpdater;
    }

    private static Optional<class_1767> getWoolColor(class_1937 world, class_2338 pos) {
        class_2338 woolPos;
        if (!MicroTimingLoggerManager.isLoggerActivated() || !MicroTimingUtil.isPositionAvailable(world, pos)) {
            return Optional.empty();
        }
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        if (block instanceof class_2426 || block instanceof class_2337 || block instanceof class_2665 || block instanceof class_2667) {
            woolPos = pos.method_10093(((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10153());
        } else if (block instanceof class_2269 || block instanceof class_2401) {
            class_2350 facing = state.method_11654((class_2769)class_2741.field_12555) == class_2738.field_12475 ? class_2350.field_11036 : (state.method_11654((class_2769)class_2741.field_12555) == class_2738.field_12473 ? class_2350.field_11033 : (class_2350)state.method_11654((class_2769)class_2741.field_12481));
            woolPos = pos.method_10093(facing.method_10153());
        } else if (block instanceof class_2458 || block instanceof class_2537) {
            woolPos = pos.method_10093(((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10153());
        } else if (block instanceof class_2241 || block instanceof class_2312 || block instanceof class_2459 || block instanceof class_2457 || block instanceof class_2231) {
            woolPos = pos.method_10074();
        } else {
            return Optional.empty();
        }
        return Optional.ofNullable(WoolTool.getWoolColorAtPosition((class_1937)world, (class_2338)woolPos));
    }

    private static Optional<class_1767> getEndRodWoolColor(class_1937 world, class_2338 pos) {
        if (!MicroTimingLoggerManager.isLoggerActivated() || !MicroTimingUtil.isPositionAvailable(world, pos)) {
            return Optional.empty();
        }
        for (class_2350 facing : DIRECTION_VALUES) {
            class_2338 woolPos;
            class_1767 color;
            class_2338 blockEndRodPos = pos.method_10093(facing);
            class_2680 iBlockState = world.method_8320(blockEndRodPos);
            if (iBlockState.method_26204() != class_2246.field_10455 || ((class_2350)iBlockState.method_11654((class_2769)class_2318.field_10927)).method_10153() != facing || (color = WoolTool.getWoolColorAtPosition((class_1937)world, (class_2338)(woolPos = blockEndRodPos.method_10093(facing)))) == null) continue;
            return Optional.of(color);
        }
        return Optional.empty();
    }

    public static Optional<class_1767> blockUpdateColorGetter(class_1937 world, class_2338 pos) {
        Optional<class_1767> optionalDyeColor = Optional.empty();
        if (CarpetTISAdditionSettings.microTimingTarget != MicroTimingTarget.MARKER_ONLY) {
            optionalDyeColor = MicroTimingUtil.getEndRodWoolColor(world, pos);
        }
        if (!optionalDyeColor.isPresent()) {
            optionalDyeColor = MicroTimingMarkerManager.getInstance().getColor(world, pos, MicroTimingMarkerType.END_ROD);
        }
        return optionalDyeColor;
    }

    public static Optional<class_1767> defaultColorGetter(class_1937 world, class_2338 pos) {
        Optional<class_1767> markerColor;
        Optional<Object> optionalDyeColor = Optional.empty();
        boolean usingFallbackColor = false;
        if (CarpetTISAdditionSettings.microTimingTarget != MicroTimingTarget.MARKER_ONLY) {
            optionalDyeColor = MicroTimingUtil.getWoolColor(world, pos);
            if (!optionalDyeColor.isPresent()) {
                optionalDyeColor = MicroTimingUtil.getEndRodWoolColor(world, pos);
            }
            if (!optionalDyeColor.isPresent()) {
                switch (CarpetTISAdditionSettings.microTimingTarget) {
                    case IN_RANGE: {
                        usingFallbackColor = world.method_8604((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 32.0, player -> true) != null;
                        break;
                    }
                    case ALL: {
                        usingFallbackColor = true;
                        break;
                    }
                }
                if (usingFallbackColor) {
                    optionalDyeColor = Optional.of(class_1767.field_7967);
                }
            }
        }
        if ((!optionalDyeColor.isPresent() || usingFallbackColor) && (markerColor = MicroTimingMarkerManager.getInstance().getColor(world, pos, MicroTimingMarkerType.REGULAR)).isPresent()) {
            optionalDyeColor = markerColor;
        }
        return optionalDyeColor;
    }

    public static class_5250 getFormattedDirectionText(class_2350 direction) {
        class_5250 translatedName = MicroTimingUtil.tr("direction." + direction.toString(), new Object[0]);
        char sign = direction.method_10171().method_10181() > 0 ? (char)'+' : '-';
        return Messenger.c(translatedName, String.format("w (%c%s)", Character.valueOf(sign), direction.method_10166()));
    }

    public static boolean isMarkerEnabled() {
        return MicroTimingLoggerManager.isLoggerActivated() && CarpetTISAdditionSettings.microTimingDyeMarker.equals("true");
    }

    public static boolean isPlayerSubscribed(class_1657 playerEntity) {
        Map map = LoggerRegistry.getPlayerSubscriptions((String)playerEntity.method_7334().name());
        return map != null && map.containsKey("microTiming");
    }

    public static List<class_3222> getSubscribedPlayers() {
        return CarpetTISAdditionServer.minecraft_server == null ? Collections.emptyList() : CarpetTISAdditionServer.minecraft_server.method_3760().method_14571().stream().filter(MicroTimingUtil::isPlayerSubscribed).collect(Collectors.toList());
    }
}

