/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.tickwarp;

public interface TickWarpInfoReader {
    public boolean isWarping();

    public long getTotalTicks();

    public long getRemainingTicks();

    public long getElapsedTime();

    default public long getCompletedTicks() {
        return this.getTotalTicks() - this.getRemainingTicks();
    }

    default public double getAverageMSPT() {
        double milliSeconds = (double)Math.max(this.getElapsedTime(), 1L) / 1000000.0;
        return milliSeconds / (double)this.getCompletedTicks();
    }

    default public double getAverageTPS() {
        double secondPerTick = this.getAverageMSPT() / 1000.0;
        return 1.0 / secondPerTick;
    }

    default public double getProgressRate() {
        return (double)this.getCompletedTicks() / (double)Math.max(this.getTotalTicks(), 1L);
    }
}

