/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.carpet.tweaks.loggerRestriction;

import carpet.commands.LogCommand;
import carpet.logging.Logger;
import carpet.logging.LoggerRegistry;
import carpettisaddition.helpers.carpet.loggerRestriction.CarpetLoggerRestriction;
import carpettisaddition.helpers.carpet.loggerRestriction.RestrictionCheckResult;
import carpettisaddition.utils.Messenger;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LogCommand.class})
public abstract class LogCommandMixin {
    @Inject(method={"toggleSubscription"}, at={@At(value="INVOKE", target="Lcarpet/logging/LoggerRegistry;togglePlayerSubscription(Ljava/lang/String;Ljava/lang/String;)Z", remap=false)}, cancellable=true)
    private static void switchableLogger_toggleCommand(class_2168 source, String player_name, String logName, CallbackInfoReturnable<Integer> cir, @Local class_1657 player) {
        LogCommandMixin.checkLoggerRestriction(source, LoggerRegistry.getLogger((String)logName), player, null, cir);
    }

    @Inject(method={"subscribePlayer"}, at={@At(value="INVOKE", target="Lcarpet/logging/LoggerRegistry;subscribePlayer(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", remap=false)}, cancellable=true)
    private static void switchableLogger_subscribeCommand(class_2168 source, String player_name, String logName, String option, CallbackInfoReturnable<Integer> cir, @Local class_1657 player) {
        LogCommandMixin.checkLoggerRestriction(source, LoggerRegistry.getLogger((String)logName), player, option, cir);
    }

    @Unique
    private static void checkLoggerRestriction(class_2168 source, Logger logger, class_1657 player, String option, CallbackInfoReturnable<Integer> cir) {
        if (logger == null) {
            return;
        }
        RestrictionCheckResult result = CarpetLoggerRestriction.checkLoggerSubscribable(logger, player, option);
        if (!result.isPassed()) {
            Messenger.tell(source, Objects.requireNonNull(result.getErrorMessage()));
            cir.setReturnValue((Object)0);
        }
    }
}

