/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.carpet.tweaks.loggerRestriction;

import carpet.logging.Logger;
import carpettisaddition.helpers.carpet.loggerRestriction.RestrictionCheckResult;
import carpettisaddition.helpers.carpet.loggerRestriction.RestrictiveLogger;
import carpettisaddition.helpers.carpet.loggerRestriction.SubscriptionChecker;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.class_1657;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Logger.class})
public abstract class LoggerMixin
implements RestrictiveLogger {
    @Unique
    private final List<SubscriptionChecker> subscriptionCheckers = Lists.newArrayList();

    @Override
    public void addSubscriptionRestriction(SubscriptionChecker subscriptionChecker) {
        this.subscriptionCheckers.add(subscriptionChecker);
    }

    @Override
    public RestrictionCheckResult canPlayerSubscribe(class_1657 player, @Nullable String option) {
        for (SubscriptionChecker checker : this.subscriptionCheckers) {
            RestrictionCheckResult result = checker.check(player, option);
            if (result.isPassed()) continue;
            return result;
        }
        return RestrictionCheckResult.ok();
    }
}

