/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.logger.lightqueue;

import carpettisaddition.logging.loggers.lightqueue.IServerLightingProvider;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.class_3227;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3227.class})
public abstract class ServerLightingProviderMixin
implements IServerLightingProvider {
    @Unique
    private final AtomicLong enqueuedTaskCount = new AtomicLong();
    @Unique
    private final AtomicLong executedTaskCount = new AtomicLong();
    @Unique
    private final AtomicLong queueSize = new AtomicLong();

    @Inject(method={"addTask(IILjava/util/function/IntSupplier;Lnet/minecraft/server/level/ThreadedLevelLightEngine$TaskType;Ljava/lang/Runnable;)V"}, at={@At(value="TAIL")})
    private void onEnqueuedLightUpdateTask(CallbackInfo ci) {
        this.enqueuedTaskCount.getAndIncrement();
        this.queueSize.getAndIncrement();
    }

    @Override
    public void onExecutedLightUpdates$TISCM() {
        this.executedTaskCount.getAndIncrement();
        this.queueSize.getAndDecrement();
    }

    @Inject(method={"runUpdate"}, at={@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/objects/ObjectListIterator;remove()V", remap=false)})
    private void onExecutedLightUpdates(CallbackInfo ci) {
        this.onExecutedLightUpdates$TISCM();
    }

    @Override
    public long getEnqueuedTaskCountAndClean$TISCM() {
        return this.enqueuedTaskCount.getAndSet(0L);
    }

    @Override
    public long getExecutedTaskCountAndClean$TISCM() {
        return this.executedTaskCount.getAndSet(0L);
    }

    @Override
    public long getQueueSize$TISCM() {
        return this.queueSize.get();
    }
}

