/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.rule.optimizedFastEntityMovement;

import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.helpers.rule.optimizedFastEntityMovement.OFEMContext;
import carpettisaddition.helpers.rule.optimizedFastEntityMovement.OFEMUtil;
import carpettisaddition.utils.mixin.testers.LithiumEntityMovementOptimizationTester;
import com.google.common.collect.Lists;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Restriction(conflict={@Condition(type=Condition.Type.TESTER, tester=LithiumEntityMovementOptimizationTester.class)})
@Mixin(value={class_1297.class})
public abstract class EntityMixin {
    @Unique
    private static final ThreadLocal<OFEMContext> ofemContext = ThreadLocal.withInitial(() -> null);
    @Unique
    private static final ThreadLocal<Boolean> movementOk = ThreadLocal.withInitial(() -> false);

    @ModifyVariable(method={"collideBoundingBox"}, at=@At(value="HEAD"), argsOnly=true)
    private static class_243 optimizedFastEntityMovement_checkMovement(class_243 movement) {
        if (CarpetTISAdditionSettings.optimizedFastEntityMovement) {
            movementOk.set(OFEMUtil.checkMovement(movement));
        }
        return movement;
    }

    @WrapOperation(method={"collectColliders"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBlockCollisions(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;)Ljava/lang/Iterable;")})
    private static Iterable<class_265> optimizedFastEntityMovement_dontUseThatLargeBlockCollisions(class_1937 world, class_1297 entity, class_238 box, Operation<Iterable<class_265>> original) {
        boolean ok;
        if (CarpetTISAdditionSettings.optimizedFastEntityMovement && (ok = movementOk.get().booleanValue())) {
            ofemContext.set(OFEMUtil.createContext(world, entity));
            return Collections.emptyList();
        }
        ofemContext.remove();
        return (Iterable)original.call(new Object[]{world, entity, box});
    }

    @ModifyExpressionValue(method={"collideWithShapes"}, at={@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z", ordinal=0)})
    private static boolean optimizedFastEntityMovement_theCollisionsListParameterIsIncompleteSoDontReturnEvenIfItIsEmpty(boolean isEmpty) {
        if (ofemContext.get() != null) {
            isEmpty = false;
        }
        return isEmpty;
    }

    @ModifyArgs(method={"collideWithShapes"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/shapes/Shapes;collide(Lnet/minecraft/core/Direction$Axis;Lnet/minecraft/world/phys/AABB;Ljava/lang/Iterable;D)D"))
    private static void optimizedFastEntityMovement_useTheAxisOnlyBlockCollisionsForSpeed(Args args) {
        OFEMContext ctx = ofemContext.get();
        if (ctx != null) {
            class_2350.class_2351 axis = (class_2350.class_2351)args.get(0);
            class_238 entityBoundingBox = (class_238)args.get(1);
            List entityAndBorderCollisions = (List)args.get(2);
            double maxDist = (Double)args.get(3);
            ctx.axis = axis;
            ctx.movementOnAxis = maxDist;
            ctx.entityBoundingBox = entityBoundingBox;
            Iterable<class_265> blockCollisions = OFEMUtil.getAxisOnlyBlockCollision(ctx);
            ArrayList voxelShapeList = Lists.newArrayList();
            voxelShapeList.addAll(entityAndBorderCollisions);
            blockCollisions.forEach(voxelShapeList::add);
            args.set(2, (Object)voxelShapeList);
        }
    }
}

