/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.utils;

import carpettisaddition.utils.GameUtils;
import carpettisaddition.utils.Messenger;
import net.minecraft.class_5250;

public class CounterUtils {
    private static final int MS_PER_TICK = 50;

    public static long getTimeElapsed(long startTick, long startMillis, boolean realtime) {
        return Math.max(1L, realtime ? (System.currentTimeMillis() - startMillis) / 50L : GameUtils.getGameTime() - startTick);
    }

    public static double tickToMinute(long ticks) {
        return (double)ticks / 1200.0;
    }

    public static double tickToHour(long ticks) {
        return (double)ticks / 72000.0;
    }

    private static double getRatePerHourValue(long amount, long ticks) {
        return (double)amount / CounterUtils.tickToHour(ticks);
    }

    public static String ratePerHour(long amount, long ticks) {
        return String.format("%d, (%.1f/h)", amount, CounterUtils.getRatePerHourValue(amount, ticks));
    }

    public static String ratePerHour(int amount, long ticks) {
        return CounterUtils.ratePerHour((long)amount, ticks);
    }

    public static class_5250 ratePerHourText(long amount, long ticks, String fmt) {
        assert (fmt.length() == 3);
        return Messenger.c(fmt.charAt(0) + " " + amount, fmt.charAt(1) + " , (", String.format("%s %.1f", Character.valueOf(fmt.charAt(2)), CounterUtils.getRatePerHourValue(amount, ticks)), fmt.charAt(1) + " /h)");
    }

    public static class_5250 ratePerHourText(int amount, long ticks, String fmt) {
        return CounterUtils.ratePerHourText((long)amount, ticks, fmt);
    }
}

