/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.utils.command;

import carpettisaddition.utils.command.BuilderDefinition;
import carpettisaddition.utils.command.BuilderFactory;
import carpettisaddition.utils.command.CommandBuilder;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class BrigadierCommandBuilder<S>
implements CommandBuilder<S> {
    private final Map<String, Command<S>> commands = Maps.newHashMap();
    private final Map<String, BuilderDefinition<S, RequiredArgumentBuilder<S, ?>>> arguments = Maps.newHashMap();
    private final Map<String, BuilderDefinition<S, LiteralArgumentBuilder<S>>> literals = Maps.newHashMap();
    private List<ArgumentBuilder<S, ?>> buildCache = null;

    private static boolean isArg(String name) {
        return name.length() >= 3 && name.charAt(0) == '<' && name.charAt(name.length() - 1) == '>';
    }

    private static boolean isOptional(String name) {
        return name.length() >= 3 && name.charAt(0) == '[' && name.charAt(name.length() - 1) == ']';
    }

    private static String makeArg(String name) {
        return "<" + name + ">";
    }

    private static String stripArg(String name) {
        return BrigadierCommandBuilder.isArg(name) ? name.substring(1, name.length() - 1) : name;
    }

    private static String stripOpt(String name) {
        return BrigadierCommandBuilder.isOptional(name) ? name.substring(1, name.length() - 1) : name;
    }

    @Override
    public void command(String command, Command<S> callback) {
        boolean hasOpt = false;
        ArrayList segments = Lists.newArrayList();
        Runnable addCommand = () -> this.commands.put(Joiner.on((String)" ").join((Iterable)segments), callback);
        for (String s : command.split(" ")) {
            if (s.isEmpty()) continue;
            boolean isOpt = BrigadierCommandBuilder.isOptional(s);
            if (hasOpt && !isOpt) {
                throw new IllegalArgumentException("Cannot have regular segment after optional segments: " + s);
            }
            if (isOpt) {
                hasOpt = true;
                if (segments.isEmpty()) {
                    throw new IllegalArgumentException("Cannot have optional segment at the beginning: " + s);
                }
                addCommand.run();
            }
            segments.add(BrigadierCommandBuilder.stripOpt(s));
        }
        addCommand.run();
    }

    @Override
    public <V> BuilderDefinition<S, RequiredArgumentBuilder<S, V>> argument(String argument, BuilderFactory<RequiredArgumentBuilder<S, V>> builderFactory) {
        BuilderDefinition definition = new BuilderDefinition(builderFactory);
        this.arguments.put(BrigadierCommandBuilder.stripArg(argument), definition);
        this.clearCache();
        return definition;
    }

    @Override
    public <V> BuilderDefinition<S, RequiredArgumentBuilder<S, V>> argument(String argument, ArgumentType<V> argumentType) {
        BuilderFactory<RequiredArgumentBuilder<S, V>> builderFactory = name -> RequiredArgumentBuilder.argument((String)name, (ArgumentType)argumentType);
        return this.argument(argument, builderFactory);
    }

    @Override
    public BuilderDefinition<S, LiteralArgumentBuilder<S>> literal(String argument) {
        BuilderDefinition definition = new BuilderDefinition(LiteralArgumentBuilder::literal);
        this.literals.put(argument, definition);
        this.clearCache();
        return definition;
    }

    private BuilderHolder<S> locateOrCreateChild(BuilderHolder<S> parent, String nodeName, @Nullable Command<S> callback) {
        BuilderHolder target = null;
        for (BuilderHolder child : parent.children) {
            String childName = child.name;
            if (child.builder instanceof RequiredArgumentBuilder) {
                childName = BrigadierCommandBuilder.makeArg(childName);
            }
            if (!nodeName.equals(childName)) continue;
            target = child;
            break;
        }
        if (target == null) {
            BuilderDefinition<S, RequiredArgumentBuilder<S, ?>> definition;
            boolean isArg = BrigadierCommandBuilder.isArg(nodeName);
            nodeName = BrigadierCommandBuilder.stripArg(nodeName);
            if (isArg) {
                definition = this.arguments.get(nodeName);
                if (definition == null) {
                    throw new IllegalArgumentException("Undefined arg " + nodeName);
                }
            } else {
                definition = this.literals.getOrDefault(nodeName, new BuilderDefinition(LiteralArgumentBuilder::literal));
            }
            target = new BuilderHolder<S>(definition.createBuilder(nodeName), nodeName);
            parent.children.add(target);
        }
        if (callback != null) {
            target.builder.executes(callback);
        }
        return target;
    }

    private void finalizeBuilders(BuilderHolder<S> holder) {
        for (BuilderHolder child : holder.children) {
            this.finalizeBuilders(child);
            holder.builder.then(child.builder);
        }
    }

    @Override
    public List<ArgumentBuilder<S, ?>> build() {
        if (this.buildCache == null) {
            BuilderHolder root = new BuilderHolder(null, null);
            this.commands.forEach((command, callback) -> {
                BuilderHolder<S> node = root;
                String[] segments = command.split(" ");
                for (int i = 0; i < segments.length; ++i) {
                    if (segments[i].length() <= 0) continue;
                    node = this.locateOrCreateChild(node, segments[i], (Command<S>)(i == segments.length - 1 ? callback : null));
                }
            });
            ArrayList nodes = Lists.newArrayList();
            for (BuilderHolder node : root.children) {
                this.finalizeBuilders(node);
                nodes.add(node.builder);
            }
            this.buildCache = nodes;
        }
        return this.buildCache;
    }

    @Override
    public void addAsChildren(ArgumentBuilder<S, ?> parent) {
        this.build().forEach(arg_0 -> parent.then(arg_0));
    }

    @Override
    public void clearCache() {
        this.buildCache = null;
    }

    private static class BuilderHolder<S> {
        public final ArgumentBuilder<S, ?> builder;
        public final String name;
        public final List<BuilderHolder<S>> children;

        private BuilderHolder(ArgumentBuilder<S, ?> builder, String name) {
            this.builder = builder;
            this.name = name;
            this.children = Lists.newArrayList();
        }
    }
}

