/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.utils.deobfuscator;

import carpettisaddition.translations.Translator;
import carpettisaddition.utils.EnvironmentUtils;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.deobfuscator.StackTraceDeobfuscator;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.spongepowered.include.com.google.common.collect.Lists;

public class StackTracePrinter {
    private static final int MAX_COPY_STACK_TRACE_SIZE = 64;
    private static final int MAX_HOVER_STACK_TRACE_SIZE = 16;
    private static final Translator translator = StackTraceDeobfuscator.translator;
    private StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
    private String ignorePackagePath;
    private static final Pattern MIXIN_METHOD_NAME_UID_PATTERN = Pattern.compile("^[a-z]{3}[0-9a-f]{3}$");
    private static final Pattern MIXIN_EXTRAS_METHOD_PATTERN_1 = Pattern.compile("^mixinextras\\$bridge\\$.+");
    private static final Pattern MIXIN_EXTRAS_METHOD_PATTERN_2 = Pattern.compile(".+\\$mixinextras\\$wrapped$");

    private StackTracePrinter() {
    }

    public static StackTracePrinter create() {
        return new StackTracePrinter();
    }

    public static class_5250 makeSymbol(Class<?> ignoreClass) {
        return StackTracePrinter.create().ignore(ignoreClass).deobfuscate().toSymbolText();
    }

    public StackTracePrinter ignore(String ignorePackagePath) {
        this.ignorePackagePath = ignorePackagePath;
        return this;
    }

    public StackTracePrinter ignore(Class<?> ignoreClass) {
        return this.ignore(ignoreClass.getPackage().getName());
    }

    public StackTracePrinter deobfuscate() {
        this.stackTrace = StackTraceDeobfuscator.deobfuscateStackTrace(this.stackTrace, this.ignorePackagePath);
        return this;
    }

    private String createClipboardString() {
        int num = Integer.min(this.stackTrace.length, 64);
        ArrayList lines = Lists.newArrayList();
        if (EnvironmentUtils.isMinecraftObfuscated()) {
            lines.add(String.format("%s (%s)", translator.tr("deobfuscated_stack_trace", new Object[0]).getString(), StackTraceDeobfuscator.MAPPING_VERSION));
        } else {
            lines.add(translator.tr("stack_trace", new Object[0]).getString());
        }
        for (int i = 0; i < num; ++i) {
            lines.add(this.stackTrace[i].toString());
        }
        int restLineCount = this.stackTrace.length - num;
        if (restLineCount > 0) {
            lines.add(translator.tr("n_more_lines", restLineCount).getString());
        }
        return Joiner.on((String)"\n").join((Iterable)lines);
    }

    private static boolean shouldObscureMethod(String methodName) {
        return MIXIN_EXTRAS_METHOD_PATTERN_1.matcher(methodName).matches() || MIXIN_EXTRAS_METHOD_PATTERN_2.matcher(methodName).matches();
    }

    private class_5250 createHoverText() {
        class_5250 text = translator.tr(EnvironmentUtils.isMinecraftObfuscated() ? "deobfuscated_stack_trace_hover" : "stack_trace_hover", new Object[0]);
        int num = Integer.min(this.stackTrace.length, 16);
        for (int i = 0; i < num; ++i) {
            StackTraceElement ste = this.stackTrace[i];
            class_5250 line = Messenger.s("");
            String className = ste.getClassName();
            String[] classNameParts = className.split("\\.");
            if (classNameParts.length >= 1) {
                line.method_10852((class_2561)Messenger.s((Object)classNameParts[classNameParts.length - 1], class_124.field_1068));
                line.method_10852((class_2561)Messenger.s((Object)".", class_124.field_1063));
            }
            line.method_10852((class_2561)class_156.method_656(() -> {
                String methodName = ste.getMethodName();
                if (StackTracePrinter.shouldObscureMethod(methodName)) {
                    return Messenger.s((Object)methodName, class_124.field_1063);
                }
                String[] methodNameParts = methodName.split("\\$");
                if (methodNameParts.length == 3 || methodNameParts.length == 4) {
                    String prefix = methodNameParts[0];
                    String uid = methodNameParts[1];
                    String modId = methodNameParts.length == 4 ? methodNameParts[2] : "";
                    String originName = methodNameParts[methodNameParts.length - 1];
                    if (MIXIN_METHOD_NAME_UID_PATTERN.matcher(uid).matches()) {
                        return Messenger.join(Messenger.s((Object)"$", class_124.field_1063), Messenger.s((Object)prefix, class_124.field_1063), Messenger.s((Object)uid, class_124.field_1063), Messenger.s((Object)modId, class_124.field_1065), Messenger.s((Object)originName, class_124.field_1054));
                    }
                }
                return Messenger.s((Object)methodName, class_124.field_1054);
            }));
            line.method_10852((class_2561)Messenger.s((Object)"()", class_124.field_1080));
            text.method_10852((class_2561)Messenger.newLine());
            text.method_10852((class_2561)line);
        }
        int restLineCount = this.stackTrace.length - num;
        if (restLineCount > 0) {
            text.method_10852((class_2561)Messenger.newLine());
            text.method_10852((class_2561)Messenger.formatting(translator.tr("n_more_lines", restLineCount), class_124.field_1080));
        }
        return text;
    }

    public class_5250 toSymbolText() {
        return Messenger.fancy("f", Messenger.s("$"), this.createHoverText(), Messenger.ClickEvents.copyToClipBoard(this.createClipboardString()));
    }
}

