/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.utils.entityfilter;

import carpettisaddition.mixins.utils.entityfilter.EntitySelectorAccessor;
import carpettisaddition.translations.TranslationContext;
import carpettisaddition.utils.CommandUtils;
import carpettisaddition.utils.EntityUtils;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.compat.DimensionWrapper;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2300;
import net.minecraft.class_2303;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityFilter
extends TranslationContext
implements Predicate<class_1297> {
    private final EntitySelectorAccessor entitySelector;
    private final class_2168 serverCommandSource;

    public EntityFilter(@NotNull class_2168 serverCommandSource, @NotNull class_2300 entitySelector) {
        super("util.entity_filter");
        this.entitySelector = (EntitySelectorAccessor)entitySelector;
        this.serverCommandSource = serverCommandSource;
    }

    public static EntityFilter create(class_3222 player, String filterDescriptor) throws CommandSyntaxException {
        class_2168 source = CommandUtils.getPlayerCommandSource(player);
        class_2303 reader = new class_2303(new StringReader(filterDescriptor), CommandUtils.hasPermissionLevel(source, 2));
        return new EntityFilter(source, reader.method_9882());
    }

    public static Optional<EntityFilter> createOptional(class_1657 player, String filterDescriptor) {
        if (!(player instanceof class_3222)) {
            return Optional.empty();
        }
        try {
            return Optional.of(EntityFilter.create((class_3222)player, filterDescriptor));
        }
        catch (CommandSyntaxException e) {
            return Optional.empty();
        }
    }

    private class_243 getAnchorPos() {
        return this.entitySelector.getPositionOffset().apply(this.serverCommandSource.method_9222());
    }

    @Nullable
    private class_238 getOffsetBox(class_243 anchorPos) {
        class_238 box = this.entitySelector.getBox();
        return box == null ? null : box.method_997(anchorPos);
    }

    @Override
    public boolean test(class_1297 testEntity) {
        if (testEntity == null) {
            return false;
        }
        if (this.entitySelector.getPlayerName() != null) {
            class_3222 serverPlayerEntity = this.serverCommandSource.method_9211().method_3760().method_14566(this.entitySelector.getPlayerName());
            return testEntity == serverPlayerEntity;
        }
        if (this.entitySelector.getUuid() != null) {
            for (class_3218 serverWorld : this.serverCommandSource.method_9211().method_3738()) {
                class_1297 entity = serverWorld.method_66347(this.entitySelector.getUuid());
                if (testEntity != entity) continue;
                return true;
            }
            return false;
        }
        class_243 anchorPos = this.getAnchorPos();
        class_238 offsetBox = this.getOffsetBox(anchorPos);
        Predicate<class_1297> predicate = this.entitySelector.invokeGetPositionPredicate(anchorPos, offsetBox, this.serverCommandSource.method_45549());
        if (this.entitySelector.getSenderOnly() && testEntity != this.serverCommandSource.method_9228()) {
            return false;
        }
        if (this.entitySelector.getLocalWorldOnly() && EntityUtils.getEntityWorld(testEntity) != this.serverCommandSource.method_9225()) {
            return false;
        }
        if (this.entitySelector.getEntityFilter() != null && this.entitySelector.getEntityFilter().method_31796((Object)testEntity) == null) {
            return false;
        }
        if (offsetBox != null && !testEntity.method_5829().method_994(offsetBox)) {
            return false;
        }
        return predicate.test(testEntity);
    }

    public class_5250 toText() {
        String inputText = this.entitySelector.getInputText$TISCM();
        return Messenger.fancy("y", Messenger.s(inputText), Messenger.c(this.tr("dimension", new Object[0]), "w : ", Messenger.dimension(DimensionWrapper.of((class_1937)this.serverCommandSource.method_9225())), "w \n", this.tr("anchor_pos", new Object[0]), "w : ", Messenger.s(this.getAnchorPos().toString())), Messenger.ClickEvents.suggestCommand(inputText));
    }
}

