/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynresources;

import com.google.common.collect.Iterators;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class DisjointSetUnion<T>
extends AbstractSet<T> {
    private final Set<T> set1;
    private final Set<T> set2;

    public DisjointSetUnion(Set<T> set1, Set<T> set2) {
        this.set1 = set1;
        this.set2 = set2;
        this.assertDisjoint();
    }

    private void assertDisjoint() {
        Set<T> iterate = this.set1.size() < this.set2.size() ? this.set1 : this.set2;
        Set<T> contains = this.set1 == iterate ? this.set2 : this.set1;
        for (T obj : iterate) {
            if (!contains.contains(obj)) continue;
            throw new IllegalArgumentException("Provided sets are not disjoint");
        }
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.concat(this.set1.iterator(), this.set2.iterator());
    }

    @Override
    public int size() {
        return this.set1.size() + this.set2.size();
    }

    @Override
    public boolean remove(Object o) {
        return this.set1.remove(o) || this.set2.remove(o);
    }

    @Override
    public boolean contains(Object o) {
        return this.set1.contains(o) || this.set2.contains(o);
    }

    @Override
    public int hashCode() {
        return this.set1.hashCode() + this.set2.hashCode();
    }
}

