/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.render.font;

import java.lang.reflect.Array;
import net.minecraft.class_391;

public class CompactUnihexContents {
    private static final boolean TEST_ROUNDTRIP = false;

    private static long extract8Bytes(byte[] arr, int off) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l |= ((long)arr[off + i] & 0xFFL) << i * 8;
        }
        return l;
    }

    private static byte extractByte(long compressed, int off) {
        return (byte)(compressed >> off * 8 & 0xFFL);
    }

    private static long extract4Shorts(short[] arr, int off) {
        long l = 0L;
        for (int i = 0; i < 4; ++i) {
            l |= ((long)arr[off + i] & 0xFFFFL) << i * 16;
        }
        return l;
    }

    private static short extractShort(long compressed, int off) {
        return (short)(compressed >> off * 16 & 0xFFFFL);
    }

    private static void verifyRoundTrip(Object originalArray, class_391.class_8544 data, int shift) {
        for (int i = 0; i < 16; ++i) {
            int actualVal;
            int val = Array.getInt(originalArray, i) << shift;
            if (val != (actualVal = data.method_51668(i))) {
                throw new AssertionError((Object)"Value at index %d differs. Expected %08x, got %08x".formatted(i, val, actualVal));
            }
        }
    }

    public static class Shorts
    implements class_391.class_8544 {
        private final long b0;
        private final long b4;
        private final long b8;
        private final long b12;

        public Shorts(short[] contents) {
            this.b0 = CompactUnihexContents.extract4Shorts(contents, 0);
            this.b4 = CompactUnihexContents.extract4Shorts(contents, 4);
            this.b8 = CompactUnihexContents.extract4Shorts(contents, 8);
            this.b12 = CompactUnihexContents.extract4Shorts(contents, 12);
        }

        public int method_51668(int index) {
            if (index < 0 || index >= 16) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (index < 4) {
                return CompactUnihexContents.extractShort(this.b0, index) << 16;
            }
            if (index < 8) {
                return CompactUnihexContents.extractShort(this.b4, index - 4) << 16;
            }
            if (index < 12) {
                return CompactUnihexContents.extractShort(this.b8, index - 8) << 16;
            }
            return CompactUnihexContents.extractShort(this.b12, index - 12) << 16;
        }

        public int comp_1512() {
            return 16;
        }
    }

    public static class Bytes
    implements class_391.class_8544 {
        private final long b0;
        private final long b8;

        public Bytes(byte[] contents) {
            this.b0 = CompactUnihexContents.extract8Bytes(contents, 0);
            this.b8 = CompactUnihexContents.extract8Bytes(contents, 8);
        }

        public int method_51668(int index) {
            if (index < 0 || index >= 16) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (index < 8) {
                return CompactUnihexContents.extractByte(this.b0, index) << 24;
            }
            return CompactUnihexContents.extractByte(this.b8, index - 8) << 24;
        }

        public int comp_1512() {
            return 8;
        }
    }
}

