/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.config.category;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Module;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import io.github.cdagaming.unicore.impl.HashMapBuilder;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class Entity
extends Module
implements Serializable {
    private static final long serialVersionUID = -4294690176016925084L;
    private static final Entity DEFAULT = new Entity();
    public String fallbackEntityIcon = "unknown";
    public Map<String, ModuleData> targetData = new HashMapBuilder().put((Object)"default", (Object)new ModuleData(Constants.TRANSLATOR.translate("craftpresence.defaults.advanced.entity_target_messages", new Object[0]), null)).build();
    public Map<String, ModuleData> ridingData = new HashMapBuilder().put((Object)"default", (Object)new ModuleData(Constants.TRANSLATOR.translate("craftpresence.defaults.advanced.entity_riding_messages", new Object[0]), null)).build();

    public Entity(Entity other) {
        this.transferFrom(other);
    }

    public Entity() {
    }

    @Override
    public Entity getDefaults() {
        return new Entity(DEFAULT);
    }

    @Override
    public Entity copy() {
        return new Entity(this);
    }

    @Override
    public void transferFrom(Module target) {
        if (target instanceof Entity) {
            Entity data = (Entity)target;
            if (!this.equals(target)) {
                this.fallbackEntityIcon = data.fallbackEntityIcon;
                this.targetData.clear();
                for (Map.Entry<String, ModuleData> entry : data.targetData.entrySet()) {
                    this.targetData.put(entry.getKey(), new ModuleData(entry.getValue()));
                }
                this.ridingData.clear();
                for (Map.Entry<String, ModuleData> entry : data.ridingData.entrySet()) {
                    this.ridingData.put(entry.getKey(), new ModuleData(entry.getValue()));
                }
            }
        }
    }

    @Override
    public Object getProperty(String name) {
        return switch (name) {
            case "fallbackEntityIcon" -> this.fallbackEntityIcon;
            case "targetData" -> this.targetData;
            case "ridingData" -> this.ridingData;
            default -> null;
        };
    }

    @Override
    public void setProperty(String name, Object value) {
        try {
            switch (name) {
                case "fallbackEntityIcon": {
                    this.fallbackEntityIcon = (String)value;
                    break;
                }
                case "targetData": {
                    this.targetData = (Map)value;
                    break;
                }
                case "ridingData": {
                    this.ridingData = (Map)value;
                    break;
                }
            }
        }
        catch (Throwable ex) {
            this.printException(ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)obj;
        return Objects.equals(other.fallbackEntityIcon, this.fallbackEntityIcon) && Objects.equals(other.targetData, this.targetData) && Objects.equals(other.ridingData, this.ridingData);
    }

    public int hashCode() {
        return Objects.hash(this.fallbackEntityIcon, this.targetData, this.ridingData);
    }
}

