/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world;

import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_2874;

public class DimensionTypeWrapper
implements IDimensionTypeWrapper {
    private static final ConcurrentMap<String, DimensionTypeWrapper> DIMENSION_WRAPPER_BY_NAME = new ConcurrentHashMap<String, DimensionTypeWrapper>();
    private final class_2874 dimensionType;
    private final String name;

    public DimensionTypeWrapper(class_2874 dimensionType, String name) {
        this.dimensionType = dimensionType;
        this.name = name;
    }

    public static DimensionTypeWrapper getDimensionTypeWrapper(class_2874 dimensionType, String name) {
        String dimName = name;
        if (DIMENSION_WRAPPER_BY_NAME.containsKey(dimName) && DIMENSION_WRAPPER_BY_NAME.get(dimName) != null) {
            return (DimensionTypeWrapper)DIMENSION_WRAPPER_BY_NAME.get(dimName);
        }
        DimensionTypeWrapper dimensionTypeWrapper = new DimensionTypeWrapper(dimensionType, dimName);
        DIMENSION_WRAPPER_BY_NAME.put(dimName, dimensionTypeWrapper);
        return dimensionTypeWrapper;
    }

    private static String determineName(class_2874 dimensionType) {
        throw new UnsupportedOperationException("As of MC 1.21.11 the dimension type no longer stores it's name and must be determined from the level.");
    }

    public static void clearMap() {
        DIMENSION_WRAPPER_BY_NAME.clear();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasCeiling() {
        return this.dimensionType.comp_643();
    }

    @Override
    public boolean hasSkyLight() {
        return this.dimensionType.comp_642();
    }

    @Override
    public Object getWrappedMcObject() {
        return this.dimensionType;
    }

    @Override
    public boolean isTheEnd() {
        return this.getName().equalsIgnoreCase("the_end");
    }

    @Override
    public double getCoordinateScale() {
        return this.dimensionType.comp_646();
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != DimensionTypeWrapper.class) {
            return false;
        }
        DimensionTypeWrapper other = (DimensionTypeWrapper)obj;
        return other.getName().equals(this.getName());
    }
}

