/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.enums.EMinecraftColor;
import com.seibel.distanthorizons.core.generation.DhLightingEngine;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.util.ExceptionUtil;
import com.seibel.distanthorizons.core.util.TimerUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IC2meAccessor;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.ChunkPosGenStream;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.GenerationEvent;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.params.GlobalWorldGenParams;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class InternalServerGenerator {
    public static final DhLogger LOGGER = new DhLoggerBuilder().name("LOD World Gen - Internal Server").fileLevelConfig(Config.Common.Logging.logWorldGenEventToFile).build();
    public static final DhLogger CHUNK_LOAD_LOGGER = new DhLoggerBuilder().name("LOD Chunk Loading").fileLevelConfig(Config.Common.Logging.logWorldGenChunkLoadEventToFile).build();
    private static final IC2meAccessor C2ME_ACCESSOR = ModAccessorInjector.INSTANCE.get(IC2meAccessor.class);
    private static final int MS_TO_IGNORE_CHUNK_AFTER_COMPLETION = 5000;
    private static final TicketType DH_SERVER_GEN_TICKET = new TicketType(0L, 2);
    private static boolean c2meMissingWarningLogged = false;
    private final GlobalWorldGenParams params;
    private final IDhServerLevel dhServerLevel;
    private final Timer chunkSaveIgnoreTimer = TimerUtil.CreateTimer("ChunkSaveIgnoreTimer");

    public InternalServerGenerator(GlobalWorldGenParams params, IDhServerLevel dhServerLevel) {
        this.params = params;
        this.dhServerLevel = dhServerLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateChunksViaInternalServer(GenerationEvent genEvent) {
        this.runValidation();
        try {
            ArrayList<CompletionStage> getChunkFutureList = new ArrayList<CompletionStage>();
            Iterator<ChunkPos> chunkPosIterator = ChunkPosGenStream.getIterator(genEvent.minPos.getX(), genEvent.minPos.getZ(), genEvent.widthInChunks, 0);
            while (chunkPosIterator.hasNext()) {
                ChunkPos chunkPos = chunkPosIterator.next();
                CompletionStage requestChunkFuture = this.requestChunkFromServerAsync(chunkPos).whenCompleteAsync((chunk, throwable) -> {
                    Throwable actualThrowable = throwable;
                    while (actualThrowable instanceof CompletionException) {
                        actualThrowable = actualThrowable.getCause();
                    }
                    if (actualThrowable != null) {
                        boolean isShutdownException;
                        boolean bl = isShutdownException = ExceptionUtil.isShutdownException(actualThrowable) || actualThrowable.getMessage().contains("Unloaded chunk");
                        if (!isShutdownException) {
                            CHUNK_LOAD_LOGGER.warn("DistantHorizons: Couldn't load chunk [" + String.valueOf(chunkPos) + "] from server, error: [" + actualThrowable.getMessage() + "].", actualThrowable);
                        }
                    }
                });
                getChunkFutureList.add(requestChunkFuture);
            }
            ArrayList<IChunkWrapper> chunkWrappers = new ArrayList<IChunkWrapper>();
            for (int i = 0; i < getChunkFutureList.size(); ++i) {
                CompletableFuture getChunkFuture = (CompletableFuture)getChunkFutureList.get(i);
                ChunkAccess chunk2 = (ChunkAccess)getChunkFuture.join();
                if (chunk2 == null) continue;
                ChunkWrapper chunkWrapper = new ChunkWrapper(chunk2, this.dhServerLevel.getLevelWrapper());
                chunkWrapper.createDhHeightMaps();
                chunkWrappers.add(chunkWrapper);
            }
            int maxSkyLight = this.dhServerLevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
            for (int i = 0; i < chunkWrappers.size(); ++i) {
                ChunkWrapper chunkWrapper = (ChunkWrapper)chunkWrappers.get(i);
                if (!chunkWrapper.isDhBlockLightingCorrect()) {
                    DhLightingEngine.INSTANCE.bakeChunkBlockLighting(chunkWrapper, chunkWrappers, maxSkyLight);
                }
                this.dhServerLevel.updateBeaconBeamsForChunk(chunkWrapper, chunkWrappers);
                genEvent.resultConsumer.accept(chunkWrapper);
            }
        }
        finally {
            Iterator<ChunkPos> chunkPosIterator = ChunkPosGenStream.getIterator(genEvent.minPos.getX(), genEvent.minPos.getZ(), genEvent.widthInChunks, 0);
            while (chunkPosIterator.hasNext()) {
                ChunkPos chunkPos = chunkPosIterator.next();
                this.releaseChunkFromServer(this.params.mcServerLevel, chunkPos);
            }
        }
    }

    private void runValidation() {
        if (!DhApi.isDhThread() && ModInfo.IS_DEV_BUILD) {
            throw new IllegalStateException("Internal server generation should be called from one of DH's world gen thread. Current thread: [" + Thread.currentThread().getName() + "]");
        }
        if (C2ME_ACCESSOR == null && !c2meMissingWarningLogged) {
            c2meMissingWarningLogged = true;
            String c2meWarning = "C2ME missing, \nlow CPU usage and slow world gen speeds expected. \nDH is set to use MC's internal server for world gen \nthis mode is less efficient unless a mod like C2ME is present.";
            if (Config.Common.Logging.Warning.showSlowWorldGenSettingWarnings.get().booleanValue()) {
                String message = String.valueOf((Object)EMinecraftColor.ORANGE) + "Distant Horizons: slow world gen." + String.valueOf((Object)EMinecraftColor.CLEAR_FORMATTING) + "\n" + c2meWarning;
                ClientApi.INSTANCE.showChatMessageNextFrame(message);
            }
            LOGGER.warn(c2meWarning, new Object[0]);
        }
    }

    private CompletableFuture<ChunkAccess> requestChunkFromServerAsync(ChunkPos chunkPos) {
        return CompletableFuture.supplyAsync(() -> {
            ServerLevel level = this.params.mcServerLevel;
            SharedApi.CHUNK_UPDATE_QUEUE_MANAGER.addPosToIgnore(new DhChunkPos(chunkPos.x, chunkPos.z));
            level.getChunkSource().addTicketWithRadius(DH_SERVER_GEN_TICKET, chunkPos, 0);
            level.getChunkSource().distanceManager.runAllUpdates(level.getChunkSource().chunkMap);
            ChunkHolder chunkHolder = level.getChunkSource().chunkMap.getUpdatingChunkIfPresent(chunkPos.toLong());
            if (chunkHolder == null) {
                throw new IllegalStateException("No chunk chunkHolder for pos [" + String.valueOf(chunkPos) + "] after ticket has been added.");
            }
            return chunkHolder.scheduleChunkGenerationTask(ChunkStatus.FEATURES, level.getChunkSource().chunkMap).thenApply(result -> (ChunkAccess)result.orElseThrow(() -> new RuntimeException(result.getError())));
        }, (Executor)this.params.mcServerLevel.getChunkSource().chunkMap.mainThreadExecutor).thenCompose(Function.identity());
    }

    private void releaseChunkFromServer(ServerLevel level, final ChunkPos chunkPos) {
        level.getChunkSource().chunkMap.mainThreadExecutor.execute(() -> {
            try {
                level.getChunkSource().removeTicketWithRadius(DH_SERVER_GEN_TICKET, chunkPos, 0);
                level.getChunkSource().chunkMap.tick(() -> false);
                level.entityManager.tick();
                this.chunkSaveIgnoreTimer.schedule(new TimerTask(this){

                    @Override
                    public void run() {
                        SharedApi.CHUNK_UPDATE_QUEUE_MANAGER.removePosToIgnore(new DhChunkPos(chunkPos.x, chunkPos.z));
                    }
                }, 5000L);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to release chunk back to internal server. Error: [" + e.getMessage() + "]", e);
            }
        });
    }
}

