/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.fabric.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.fabric.FabricAdapter;
import com.sk89q.worldedit.fabric.internal.FabricPropertyAdapter;
import com.sk89q.worldedit.registry.state.BooleanProperty;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.EnumProperty;
import com.sk89q.worldedit.registry.state.IntegerProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3542;

public class FabricTransmogrifier {
    private static final LoadingCache<class_2769<?>, Property<?>> PROPERTY_CACHE = CacheBuilder.newBuilder().build(new CacheLoader<class_2769<?>, Property<?>>(){

        public Property<?> load(class_2769<?> property) throws Exception {
            class_2769<?> class_27692 = property;
            Objects.requireNonNull(class_27692);
            class_2769<?> class_27693 = class_27692;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2746.class, class_2758.class, class_2754.class}, class_27693, n)) {
                case 0 -> {
                    class_2746 booleanProperty = (class_2746)class_27693;
                    yield new BooleanProperty(property.method_11899(), (List<Boolean>)ImmutableList.copyOf((Collection)booleanProperty.method_11898()));
                }
                case 1 -> {
                    class_2758 integerProperty = (class_2758)class_27693;
                    yield new IntegerProperty(property.method_11899(), (List<Integer>)ImmutableList.copyOf((Collection)integerProperty.method_11898()));
                }
                case 2 -> {
                    class_2754 enumProperty = (class_2754)class_27693;
                    if (property.method_11902() == class_2350.class) {
                        yield new DirectionalProperty(property.method_11899(), (List)property.method_11898().stream().map(v -> FabricAdapter.adaptEnumFacing((class_2350)v)).collect(ImmutableList.toImmutableList()));
                    }
                    yield new EnumProperty(property.method_11899(), (List)enumProperty.method_11898().stream().map(x -> ((class_3542)x).method_15434()).collect(ImmutableList.toImmutableList()));
                }
                default -> new FabricPropertyAdapter(property);
            };
        }
    });

    public static Property<?> transmogToWorldEditProperty(class_2769<?> property) {
        return (Property)PROPERTY_CACHE.getUnchecked(property);
    }

    private static Map<Property<?>, Object> transmogToWorldEditProperties(BlockType block, Map<class_2769<?>, Comparable<?>> mcProps) {
        TreeMap props = new TreeMap(Comparator.comparing(Property::name));
        for (Map.Entry<class_2769<?>, Comparable<?>> prop : mcProps.entrySet()) {
            Object value = prop.getValue();
            if (prop.getKey() instanceof class_2754) {
                value = prop.getKey().method_11902() == class_2350.class ? FabricAdapter.adaptEnumFacing((class_2350)value) : ((class_3542)value).method_15434();
            }
            props.put(block.getProperty(prop.getKey().method_11899()), value);
        }
        return props;
    }

    private static class_2680 transmogToMinecraftProperties(class_2689<class_2248, class_2680> stateContainer, class_2680 newState, Map<Property<?>, Object> states) {
        for (Map.Entry<Property<?>, Object> state : states.entrySet()) {
            class_2769 property = stateContainer.method_11663(state.getKey().name());
            Comparable value = (Comparable)state.getValue();
            if (property instanceof class_2754) {
                if (property.method_11902() == class_2350.class) {
                    Direction dir = (Direction)((Object)value);
                    value = FabricAdapter.adapt(dir);
                } else {
                    String enumName = (String)((Object)value);
                    value = (Comparable)((class_2754)property).method_11900((String)((Object)value)).orElseThrow(() -> new IllegalStateException("Enum property " + property.method_11899() + " does not contain " + enumName));
                }
            }
            newState = (class_2680)newState.method_11657(property, value);
        }
        return newState;
    }

    public static class_2680 transmogToMinecraft(BlockState blockState) {
        class_2248 mcBlock = FabricAdapter.adapt(blockState.getBlockType());
        class_2680 newState = mcBlock.method_9564();
        Map<Property<?>, Object> states = blockState.getStates();
        return FabricTransmogrifier.transmogToMinecraftProperties((class_2689<class_2248, class_2680>)mcBlock.method_9595(), newState, states);
    }

    public static BlockState transmogToWorldEdit(class_2680 blockState) {
        BlockType blockType = FabricAdapter.adapt(blockState.method_26204());
        return blockType.getState(FabricTransmogrifier.transmogToWorldEditProperties(blockType, blockState.method_11656()));
    }

    private FabricTransmogrifier() {
    }
}

