/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.block;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypeStateList;
import java.util.Map;

final class SingletonBlockTypeStateList
extends BlockTypeStateList {
    private final BlockState state;

    SingletonBlockTypeStateList(BlockState state) {
        this.state = state;
    }

    public BlockState get(int index) {
        Preconditions.checkElementIndex((int)index, (int)1);
        return this.state;
    }

    public int size() {
        return 1;
    }

    @Override
    public int calculateIndex(Map<Property<?>, ?> state) {
        if (!state.isEmpty()) {
            throw new IllegalArgumentException("No properties expected for singleton state");
        }
        return 0;
    }

    @Override
    public int updateIndexOrInvalid(int currentIndex, Property<?> property, Object oldValue, Object newValue) {
        return -1;
    }
}

