/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.handler;

import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.client.gui.entry.DisplayEntry;
import fuzs.pickupnotifier.config.AnchorPoint;
import fuzs.pickupnotifier.config.ClientConfig;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SequencedCollection;
import net.minecraft.class_2535;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_636;
import net.minecraft.class_746;
import net.minecraft.class_8027;
import net.minecraft.class_8030;
import net.minecraft.class_9779;
import org.apache.commons.lang3.mutable.MutableInt;

public class DrawEntriesHandler {
    public static final DrawEntriesHandler INSTANCE = new DrawEntriesHandler();
    private final Map<Object, DisplayEntry<?>> collector = new LinkedHashMap();
    private final Int2ObjectArrayMap<MutableInt> handledEntities = new Int2ObjectArrayMap();

    private DrawEntriesHandler() {
    }

    public void addHandledEntity(int itemId) {
        this.handledEntities.put(itemId, (Object)new MutableInt());
    }

    public boolean isItemEntityHandled(int itemId) {
        return this.handledEntities.containsKey(itemId);
    }

    public Map<Object, DisplayEntry<?>> getCollector() {
        return this.collector;
    }

    public void onClientTick(class_310 minecraft) {
        if (minecraft.method_1493()) {
            return;
        }
        if (!((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.clientOnly && !this.handledEntities.isEmpty()) {
            this.handledEntities.values().forEach(MutableInt::increment);
            this.handledEntities.values().removeIf(mutableInt -> mutableInt.intValue() > ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.displayTime);
        }
        if (!this.collector.isEmpty()) {
            this.collector.values().forEach(DisplayEntry::tick);
            if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.displayTime != 0) {
                this.collector.values().removeIf(DisplayEntry::mayDiscard);
            }
        }
    }

    public void renderPickUpEntries(class_332 guiGraphics, class_9779 deltaTracker) {
        int posY;
        if (this.collector.isEmpty()) {
            return;
        }
        class_327 font = class_310.method_1551().field_1772;
        float partialTick = deltaTracker.method_60637(false);
        float scale = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.getDisplayScale();
        int screenWidth = (int)((float)guiGraphics.method_51421() / scale);
        int screenHeight = (int)((float)guiGraphics.method_51443() / scale);
        AnchorPoint anchorPoint = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.position;
        SequencedCollection values = this.collector.values();
        if (!anchorPoint.isTop()) {
            values = new ArrayList(values).reversed();
        }
        int maxWidth = values.stream().mapToInt(displayEntry -> displayEntry.getEntryWidth(font)).max().orElse(0);
        AnchorPoint.Positioner positioner = anchorPoint.createPositioner(screenWidth, screenHeight, maxWidth, 18 * values.size());
        int offsetX = (int)((float)((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.offsetX / scale);
        int offsetY = (int)((float)((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.offsetY / scale);
        class_8030 originalRectangle = positioner.getRectangle(offsetX, offsetY);
        int posX = positioner.getPosX(offsetX);
        int elementY = posY = positioner.getPosY(offsetY - DrawEntriesHandler.getMoveOffset(values, partialTick));
        for (DisplayEntry displayEntry2 : values) {
            int elementWidth = displayEntry2.getEntryWidth(font);
            int elementX = posX + anchorPoint.createPositioner(maxWidth, -1, elementWidth, -1).getPosX(0);
            if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.moveOut.move(class_8027.field_41822)) {
                elementX = (int)((double)elementX + (double)maxWidth * (1.0 - (double)displayEntry2.getRelativeRemainingTicks(partialTick)) * (double)anchorPoint.getNormalX());
            }
            float alpha = !((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.fadeOut ? 1.0f : (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.moveOut.move(class_8027.field_41822) || ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.moveOut.move(class_8027.field_41823) ? DrawEntriesHandler.getCoveredArea(elementX, elementY, elementWidth, originalRectangle) : displayEntry2.getRelativeRemainingTicks(partialTick));
            displayEntry2.render(guiGraphics, font, elementX, elementY, alpha);
            elementY += 18;
        }
    }

    private static int getMoveOffset(Collection<DisplayEntry<?>> values, float partialTick) {
        if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.moveOut.move(class_8027.field_41823)) {
            return (int)(DisplayEntry.getRelativeRemainingTicks(values, partialTick) * 18.0);
        }
        return 0;
    }

    private static float getCoveredArea(int elementX, int elementY, int elementWidth, class_8030 originalRectangle) {
        class_8030 elementRectangle = new class_8030(elementX, elementY, elementWidth, 18);
        class_8030 screenRectangle = DrawEntriesHandler.getScreenRectangleIntersection(originalRectangle, elementRectangle);
        int elementArea = elementRectangle.comp_1196() * elementRectangle.comp_1197();
        int intersectionArea = screenRectangle.comp_1196() * screenRectangle.comp_1197();
        return class_3532.method_15363((float)((float)intersectionArea / (float)elementArea), (float)0.0f, (float)1.0f);
    }

    private static class_8030 getScreenRectangleIntersection(class_8030 originalRectangle, class_8030 elementRectangle) {
        class_8030 screenRectangle = originalRectangle.method_49701(elementRectangle);
        if (screenRectangle != null) {
            return screenRectangle;
        }
        return class_8030.method_48248();
    }

    public void onPlayerLeave(class_746 player, class_636 multiPlayerGameMode, class_2535 connection) {
        this.collector.clear();
    }

    public void onCopy(class_746 oldPlayer, class_746 newPlayer, class_636 multiPlayerGameMode, class_2535 connection) {
        this.collector.clear();
    }
}

